<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package template
 */

?>
<?php if (get_field('display_footer_full_calltoaction') == true): ?>
    <div class="call-to-action">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php if (get_field('heading') !== ''): ?>
                        <h3><?php the_field('heading'); ?></h3>
                    <?php endif; ?>

                    <?php if (get_field('additional_message') !== ''): ?>
                        <?php the_field('additional_message'); ?>
                    <?php endif; ?>

                    <?php if (get_field('button_text') !== '' && get_field('button_link') !== ''): ?>
                        <a class="btn btn-primary"
                           href="<?php the_field('button_link') ?>"><?php the_field('button_text'); ?></a>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<footer>
    <div class="footer_navigation">
        <?php if (isset($hidden) && $hidden == true): ?>
        <?php if (get_option('footer_background')): ?>
            <img src="<?php echo get_option('footer_background'); ?>" alt="" class="background">
        <?php endif; ?>
        <?php endif; ?>
        <div class="container">
            <div class="row borders">
                <div class="footer-col-1 col-lg-4 col-md-6 col-sm-12 col-xs-12">
                    <?php dynamic_sidebar('theme-1'); ?>
                </div>
                <div class="footer-col-2 col-lg-4 col-md-6 col-sm-12 col-xs-12 hidden-md-down">
                    <?php dynamic_sidebar('theme-2'); ?>
                </div>
                <div class="footer-col-3 col-lg-4 col-md-6 col-sm-12 col-xs-12">
                    <?php dynamic_sidebar('theme-3'); ?>
                </div>
            </div>
            <?php if (isset($hidden) && $hidden == true): ?>
            <div class="row copyright_bar">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 copy">
                    <div class="copyright_navigation">
                        <?php
                        wp_nav_menu(['menu' => 'copyright', 'theme_location' => 'copyright', 'container' => 'div', 'container_id' => 'bs-navbar', 'container_class' => 'navbar-collapse', 'menu_id' => false, 'menu_class' => 'nav navbar-nav', 'depth' => 1,]);
                        ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="row company_legal">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <?php if (get_option('company_legal') !== ''): ?>
                    <span class="align-middle" style="display: block"><?php
                        echo get_option('company_legal');
                        ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="copyright_bar">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php if (get_option('company_copyright') !== ''): ?>
                        <span class="align-middle"><?php
                            $a = get_option('company_copyright');
                            if (stripos(strtolower($a), '{{year}}')) {
                                $a = str_replace('{{year}}', date('Y'), $a);
                                echo $a;
                            } else {
                                echo $a;
                            }
                            ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>
<?php echo get_option('footer_code'); ?>
</body>
</html>
