<?php

// Theme Settings Menu Page Content
function theme_services_menu_content() {
    ?>

    <div id="tecmark-admin">

        <?php
        // Check if the user has premissions to edit these settings.
        if (!current_user_can('manage_options')) {
            wp_die('You do not have sufficient permissions to access this page.');
        }
        ?>

        <h1>Your Theme Services</h1>
        <p class="subhead">
            This areas allows you to add code into the header and footer areas of the site.
        </p>

        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <h2>Site Services</h2>

                <form method="POST" action="options.php">
                    <?php
        	            settings_fields("theme_services_options");
        	            do_settings_sections("theme-services");
        	        ?>
					<div class="form-group">
						<label for="head_code">Website Head Code</label>
						<textarea name="head_code" id="head_code"><?php echo get_option('head_code'); ?></textarea>
					</div>
					<hr>
					<div class="form-group">
						<label for="tracking_code">Website Tracking Codes</label>
						<textarea name="tracking_code" id="tracking_code"><?php echo get_option('tracking_code'); ?></textarea>
					</div>
					<hr>
					<div class="form-group">
						<label for="footer_code">Website Footer Code</label>
						<textarea name="footer_code" id="footer_code"><?php echo get_option('footer_code'); ?></textarea>
					</div>
					<hr>
					<div class="form-group">
						<label for="call-to-action">Website Call-to-action</label>
						<textarea name="call-to-action" id="call-to-action"><?php echo get_option('call-to-action'); ?></textarea>
					</div>
					<?php
						submit_button();
					?>
                </form>
            </div>

            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12" id="previews">
                <h2>About this Section?</h2>
				<h5>Head Code</h5>
				<p>
					Any code added to this section will be include in the sites header. This could include extra CSS Stylesheets or Links to Google Fonts.
				</p>
				<hr>
				<h5>Tracking</h5>
				<p>
					If you want to track the preformance of your site, you can add any tracking codes here. An popular example is Google Analytics. This will be installed by Tecmark before your site is laurnched, please <strong>do not</strong> remove this.
				</p>
				<hr>
				<h5>Footer Code</h5>
				<p>
					If you want to include an extra JavaScript files or tracking codes, these can be entered here.
				</p>
			</div>
        </div>
    </div>
    <?php
}
