<?php get_header(); ?>

    <div class="full-rule">
<?php
$page_id = get_option('page_for_posts');
$banner = get_field('banner_image', $page_id);
if (!empty($banner)): ?>
    <div class="banner" style="background-image: url(<?php the_field('banner_image', $page_id); ?>);"></div>
<?php else: ?>
    <div class="banner default"></div>
<?php endif; ?>

    <div class="container full-header">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <h1><?php echo get_the_title(get_option('page_for_posts')) ?></h1>
            </div>
        </div>
    </div>


    <div class="container content">

        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
            <?php if (is_home()) :
                $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                $args = array(
                    'posts_per_page' => 6,
//                    'category_name' => 'news',
                    'paged'          => $paged,
                );
                ?>
            <?php endif; ?>

            <?php
            $query = new WP_Query($args);
            if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>

                <article class="post line">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 post blog-list">
                        <a href="<?php the_permalink() ?>">
                            <?php if (has_post_thumbnail($post->ID)): ?>
                                <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)) ?>">
                            <?php endif; ?>
                            <h3><?php the_title(); ?></h3>
                        </a>
                        <?php the_content() ?>
                    </div>
                </article>
                <?php
            endwhile;
                the_posts_pagination(array(
                    'mid_size'           => 2,
                    'prev_text'          => __('Previous', ''),
                    'next_text'          => __('Next', ''),
                    'screen_reader_text' => ' ',
                ));
            endif;wp_reset_postdata();
            ?>

        </div>
        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 sidebar hidden-md-down">
            <?php dynamic_sidebar( 'sidebar-1' ); ?>
        </div>

    </div>

<?php
get_footer();
