<?php 

/**
 *	
 */ 
 
class LandingPages {
	
	private $debug = true;
	private $blocks;
	
	public function __construct() {
		
		// Enable error reporting
		if ($this->debug){
			ini_set('display_errors', 1);
			ini_set('display_startup_errors', 1);
			error_reporting(E_ALL);
		}
		
		// Register theme image sizes. 
        $this->set_sizes();
		
		// Get the blocks array
		$this->blocks = get_field("blocks", get_the_id());
		
		// Get CTA options
		if (get_field('enable_sticky_cta')) {
			$this->render_cta();
		}
		
		
	}



	/**
     * SELF CLASS INSTANTIATION
     * This allows WordPress to instantiate this class on load.
     */
    public static function instance() {
        $class = __CLASS__;
        return (new $class);
    }
    
    
    
    /**
     * LOAD FRONTEND STYLES
     * This function allows the loading on custom frontend styles. 
     */
    public function enqueue_styles_frontend() {
	           
        wp_enqueue_style( 'landing-pages-base',      get_template_directory_uri() . '/landing-pages/dist/css/styles.min.css' );
        wp_enqueue_style( 'landing-pages-animate',   'https://unpkg.com/aos@2.3.1/dist/aos.css' );
		wp_enqueue_script( 'landing-pages-animate' , 'https://unpkg.com/aos@2.3.1/dist/aos.js', '', '', true );
		wp_enqueue_script( 'landing-pages-scripts' ,  get_template_directory_uri() . '/landing-pages/dist/js/scripts.min.js', '', '', true );

    }
    
    
    
    /**
     * THEME IMAGE SIZES
     * Here we create any custom image sizes to be used within the theme.
     * Note: Creating a new size requires 4 arguments: slug (id), width (px), height (px), crop (true/false).
     */
    public static function set_sizes() {
        add_image_size('am_media', 500, 400, true);
    }
		
	
		
	/**
	 *
	 */
	public function get_blocks() {
			
		foreach ($this->blocks as $block) {			
			
			// Include the blocks controller
			include_once( get_template_directory() . '/landing-pages/blocks/' . $block['acf_fc_layout'] . '/' . ucfirst($block['acf_fc_layout']) . '.php');
			
			// Create block class name
			$class = ucfirst($block['acf_fc_layout']);

			// Call the class
			(new $class($block));
			
			///500 by 400
		}	
	}
	
	
	
	public function render_cta() {
		
		$values = new stdClass();
		
		$values->form_id  = get_field('form_id');
		$values->cta_text = 'Get Quote';
		$values->cta_form = get_field('cta_form');
		
		include_once( get_template_directory() . '/landing-pages/cta.php');
		
	}


	/**
	 * PRINT ALL OR DATA DUMP
	 * Debugging untility for data sets. 
	 * Note: Output all data using a print_r function. 
	 * @author Joe Curran (hello@joecurran.codes)
	 * @date   Jan 12 2018
	 */
	public static function dd() {
	
		// Get all arguments passed to this function.
	    $args = func_get_args();
	
	    // For each argument passed perform value output.
	    if (is_array($args) || is_object($args)):
	        foreach ($args as $value):
	            print_r("<pre style='background-color: #f1f1f1; color: black; text-align: left; padding: 1rem;'>");
	            print_r($value);
	            print_r("</pre>");
	        endforeach;
	    endif;
	}
}