<?php
	
class Form {
	
	public $name;
	public $block;
	public $values;
	
	public function __construct($init_parameter) {
		
		// Get the block data
		$this->block = $init_parameter;
		
		// Get the block name
		$this->name = $this->block['acf_fc_layout'];
			
		// Get the block content values		
		$this->values = $this->get_values();
		
		// Render the block to the page
		$this->render_block();
		
	}
	
	
	
	/**
     * SELF CLASS INSTANTIATION
     * This allows WordPress to instantiate this class on load.
     */
    public static function instance() {
        $class = __CLASS__;
        return (new $class);
    }
    
    
    /**
	 *
	 */
	public function get_values() {
		
		$values = new stdClass();
		
		$values->layout = $this->field('layout');
		$values->form  = $this->field('form');
		
		return $values;
	}
	
	
	/**
	 *
	 */
	public function field($v) {
		
		return $this->block[$v];
		
	} 	
    
    
    
    public function render_block() {
	    	    
	    // Get the values ready for the view	    
	    $values = $this->values;
	    	    
	    // Include the block template file	    
	    include($this->name . "-" . $this->values->layout . ".php");
	    
    }
}	