<?php
/* Template Name: CommunityMax Page */
?>
<?php
get_header();
?>

	<div class="full-rule">

		<?php
		$banner = get_field('banner_image');
		if (!empty($banner)): ?>
			<div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
		<?php else: ?>
			<div class="banner default"></div>
		<?php endif; ?>
		<div class="container full-header">
			<div class="row">
				<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					<h1><?php the_title(); ?></h1>
				</div>
			</div>
		</div>

        <?php if (get_option('breadcrumbs') == true): ?>
            <div class="container hidden-sm-down">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php if ( function_exists('yoast_breadcrumb') ) {
                        echo '<sub class="breadcrumbs-nav">Navigation</sub>';
                        yoast_breadcrumb('<p id="breadcrumbs">','</p>');
                    } ?>
                </div>
            </div>
        <?php endif; ?>

		<div class="container content">

            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">

                    <?php the_content(); ?>

                    <div class="row flipboxes">

                        <?php

                        $community = get_field('community');

                        foreach ($community as $item): ?>

                            <div class="col-sm-4">
                                <div class="flip-hover panel">
                                    <div class="front">
                                        <div class="box1" style="background: url('<?php echo $item['image']; ?>'); background-position: center top; background-size: auto 100%;">
                                            <p><?php echo $item['title']; ?></p>
                                        </div>
                                    </div>
                                    <div class="back">
                                        <div class="box2">
                                            <p class="title"><?php echo $item['title']; ?></p>
                                            <?php echo $item['about']; ?>
                                            <?php if (!empty($item['more_link'])): ?>
                                                <a href="<?php echo $item['more_link']; ?>" class="btn btn-primary model open-box-1"><?php echo $item['more_button']; ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php endforeach; ?>

                    </div>
                </div>
            </div>
		</div>
	</div>
<?php
get_footer();
