<?php
/* Template Name: Contact Page */
?>
<?php
get_header();
?>

	<div class="full-rule">

		<?php
		$banner = get_field('banner_image');
		if (!empty($banner)): ?>
			<div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
		<?php else: ?>
			<div class="banner default"></div>
		<?php endif; ?>
		<div class="container full-header">
			<div class="row">
				<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					<h1><?php the_title(); ?></h1>
				</div>
			</div>
		</div>

        <?php if (get_option('breadcrumbs') == true): ?>
            <div class="container hidden-sm-down">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <?php if ( function_exists('yoast_breadcrumb') ) {
                        echo '<sub class="breadcrumbs-nav">Navigation</sub>';
                        yoast_breadcrumb('<p id="breadcrumbs">','</p>');
                    } ?>
                </div>
            </div>
        <?php endif; ?>

		<div class="container content location">

			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

				<?php if (get_field('contact_form_pre') !== ''): ?>
					<?php echo the_field('contact_form_pre'); ?>
				<?php endif; ?>


                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 sidebar">
                        <?php echo the_field('sidebar_content'); ?>
                    </div>

                    <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                        <?php the_content(); ?>
                    </div>
                </div>

			</div>
		</div>
	</div>
<?php
get_footer();
