<?php
/* Template Name: Homepage */
?>

<?php
get_header();
?>

<section class="cd-hero">
    <ul class="cd-hero-slider autoplay">
        <?php
        $args = array(
            'post_type'   => 'dpp_slider',
            'post_status' => 'publish'
        );
        $query = new WP_Query($args);
        $first = 0;
        ?>
        <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>

            <li <?php if ($first == 0) {
                echo 'class="selected"';
                $first = 1;
            } ?>>

                <?php if (get_field('full_banner_link') && get_field('full_banner_link') == true): ?>
                <a href="<?php echo get_field('full_banner_link_url'); ?>">
                    <?php endif; ?>

                    <?php
                    // CHECK THE TEXT POSITION SELECTED //
                    ?>

                    <div class="cd-full-width <?php if (get_field('colour') == false) {
                        echo "slider-dark";
                    } ?> <?php if (get_field('link_button') == false) {
                        echo "no-btn";
                    } ?> <?php the_field('position') ?>">

                        <?php //DO check for posion – dark light check // ?>

                        <?php // MAIN SLIDE TITLE // ?>
                        <?php if (get_field('title')): ?>
                            <h2><?php the_field('title'); ?></h2>
                        <?php endif; ?>

                        <?php // TAG LINE OR SECOND TEXT LINE // ?>
                        <?php if (get_field('line_2')): ?>
                            <p><?php the_field('line_2'); ?></p>
                        <?php endif; ?>

                        <?php // LINK BUTTON // ?>
                        <?php if (get_field('link_button') == true): ?>

                            <div class="button-link">

                            <?php if (get_field('link_button_url')): ?>
                                <a href="<?php the_field('link_button_url'); ?>" class="cd-btn">
                            <?php endif; ?>

                            <?php if (get_field('title')) {
                                the_field('link_button_text');
                            } ?>

                            <?php if (get_field('link_button_url')): ?>
                                </a>
                            <?php endif; ?>

                            </div>

                        <?php endif; ?>
                    </div>

                    <?php if (get_field('full_banner_link') !== '' && get_field('full_banner_link') == true): ?>
                </a>
            <?php endif; ?>


                <?php if (get_field('background_image')): ?>

                    <div class="cd-img-container">

                        <img src="<?php echo get_field('background_image'); ?>" class=""/>

                    </div>

                <?php endif; ?>

            </li>

        <?php endwhile; endif;
        wp_reset_postdata(); ?>
    </ul>
</section>

<div class="container content">

    <div class="row">

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 homepage-copy hidden-xs-down">
            <?php the_content(); ?>
            <hr>
        </div>

    </div>

    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 partners">

        <div class="row">

            <?php

                $boxes = get_field('number_of_boxes');

                if ($boxes == '3') {
                    $lg_width = '4';
                    $md_width = '12';
                } else {
                    $lg_width = '4';
                    $md_width = '12';
                }

            ?>


        <?php if (get_field('featured_box_1_url') !== ''): ?>
            <a href="<?php the_field('featured_box_1_url'); ?>">
                <?php endif; ?>

                <div class="col-lg-<?php echo $lg_width;?> col-md-<?php echo $md_width;?> col-sm-12 col-xs-12 box <?php if (get_field('use_overlay_mode') == true) { echo 'overlay-on'; } ?> <?php if (get_field('use_slide_mode') == true) { echo 'slide-on'; } ?>">

                    <?php if (get_field('featured_box_1_image') !== ''): ?>
                        <?php if (get_field('use_slide_mode') !== true): ?>
                            <div class="logo">
                                <span></span>
                                <div class="overlay"></div>
                                <img src="<?php the_field('featured_box_1_image'); ?>"
                                     alt="<?php the_field('featured_box_1_name'); ?>">
                            </div>
                        <?php else: ?>

                            <div class="logo" style="background-image: url('<?php the_field('featured_box_1_image'); ?>')">
                                <div class="slide-box">
                                    <p class="slide-title"><?php the_field('featured_box_1_name'); ?></p>
                                    <div class="slide-content"><?php the_field('featured_box_1_about'); ?></div>
                                    <div class="btn slide-btn"><?php the_field('featured_box_1_link_text'); ?></div>
                                </div>
                            </div>

                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if (get_field('use_slide_mode') !== true): ?>
                    <div class="overlay-content">
                        <div class="company"><?php the_field('featured_box_1_name'); ?></div>
                        <?php the_field('featured_box_1_about'); ?>
                        <span><?php the_field('featured_box_1_link_text'); ?></span>
                    </div>
                    <?php endif; ?>
                </div>

                <?php if (get_field('featured_box_1_url') !== ''): ?>
            </a>
        <?php endif; ?>

        <?php if (get_field('featured_box_2_url') !== ''): ?>
            <a href="<?php the_field('featured_box_2_url'); ?>">
                <?php endif; ?>

                <div class="col-lg-<?php echo $lg_width;?> col-md-<?php echo $md_width;?> col-sm-12 col-xs-12 box <?php if (get_field('use_overlay_mode') == true) { echo 'overlay-on'; } ?> <?php if (get_field('use_slide_mode') == true) { echo 'slide-on'; } ?>">

                    <?php if (get_field('featured_box_2_image') !== ''): ?>
                        <?php if (get_field('use_slide_mode') !== true): ?>
                            <div class="logo">
                                <div class="overlay"></div>
                                <img src="<?php the_field('featured_box_2_image'); ?>"
                                     alt="<?php the_field('featured_box_2_name'); ?>">
                            </div>
                        <?php else: ?>

                            <div class="logo" style="background-image: url('<?php the_field('featured_box_2_image'); ?>')">
                                <div class="slide-box">
                                    <p class="slide-title"><?php the_field('featured_box_2_name'); ?></p>
                                    <div class="slide-content"><?php the_field('featured_box_2_about'); ?></div>
                                    <div class="btn slide-btn"><?php the_field('featured_box_2_link_text'); ?></div>
                                </div>
                            </div>

                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if (get_field('use_slide_mode') !== true): ?>
                        <div class="overlay-content">
                            <div class="company"><?php the_field('featured_box_2_name'); ?></div>
                            <?php the_field('featured_box_2_about'); ?>
                            <span><?php the_field('featured_box_2_link_text'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if (get_field('featured_box_2_url') !== ''): ?>
            </a>
        <?php endif; ?>

        <?php if (get_field('featured_box_3_url') !== ''): ?>
            <a href="<?php the_field('featured_box_3_url'); ?>">
                <?php endif; ?>

                <div class="col-lg-<?php echo $lg_width;?> col-md-<?php echo $md_width;?> col-sm-12 col-xs-12 box <?php if (get_field('use_overlay_mode') == true) { echo 'overlay-on'; } ?> <?php if (get_field('use_slide_mode') == true) { echo 'slide-on'; } ?>">

                    <?php if (get_field('featured_box_3_image') !== ''): ?>
                        <?php if (get_field('use_slide_mode') !== true): ?>
                            <div class="logo">
                                <div class="overlay"></div>
                                <img src="<?php the_field('featured_box_3_image'); ?>"
                                     alt="<?php the_field('featured_box_3_name'); ?>">
                            </div>
                        <?php else: ?>

                            <div class="logo" style="background-image: url('<?php the_field('featured_box_3_image'); ?>')">
                                <div class="slide-box">
                                    <p class="slide-title"><?php the_field('featured_box_3_name'); ?></p>
                                    <div class="slide-content"><?php the_field('featured_box_3_about'); ?></div>
                                    <div class="btn slide-btn"><?php the_field('featured_box_3_link_text'); ?></div>
                                </div>
                            </div>

                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if (get_field('use_slide_mode') !== true): ?>
                        <div class="overlay-content">
                            <div class="company"><?php the_field('featured_box_3_name'); ?></div>
                            <?php the_field('featured_box_3_about'); ?>
                            <span><?php the_field('featured_box_3_link_text'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if (get_field('featured_box_3_url') !== ''): ?>
            </a>
        <?php endif; ?>

        <?php if ($boxes == 4): ?>
        <?php if (get_field('featured_box_4_url') !== ''): ?>
            <a href="<?php the_field('featured_box_4_url'); ?>">
                <?php endif; ?>

                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 box full-width-box <?php if (get_field('use_overlay_mode') == true) { echo 'overlay-on'; } ?> <?php if (get_field('use_slide_mode') == true) { echo 'slide-on'; } ?>">

                    <?php if (get_field('featured_box_4_image') !== ''): ?>
                        <?php if (get_field('use_slide_mode') !== true): ?>
                            <div class="logo">
                                <div class="overlay"></div>
                                <img src="<?php the_field('featured_box_4_image'); ?>"
                                     alt="<?php the_field('featured_box_4_name'); ?>">
                            </div>
                        <?php else: ?>

                            <div class="logo" style="background-image: url('<?php the_field('featured_box_4_image'); ?>')">
                                <div class="slide-box">
                                    <p class="slide-title"><?php the_field('featured_box_4_name'); ?></p>
                                    <div class="slide-content"><?php the_field('featured_box_4_about'); ?></div>
                                    <div class="btn slide-btn"><?php the_field('featured_box_4_link_text'); ?></div>
                                </div>
                            </div>

                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if (get_field('use_slide_mode') !== true): ?>
                        <div class="overlay-content">
                            <div class="company"><?php the_field('featured_box_4_name'); ?></div>
                            <?php the_field('featured_box_4_about'); ?>
                            <span><?php the_field('featured_box_4_link_text'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if (get_field('featured_box_4_url') !== ''): ?>
            </a>
        <?php endif; ?>
        <?php endif; ?>

        </div>

    </div>

</div>


<?php
// Ticker Slider if the Plugin is Active //
if (function_exists('kw_sc_logo_carousel')): ?>

    <div class="ticker_tape">
        <?php kw_sc_logo_carousel('homepage'); ?>
    </div>

<?php endif; ?>

<?php
get_footer();
?>
