<?php
/* Template Name: Location Page */
?>
<?php
get_header();
?>

    <div class="full-rule">

        <?php
        $banner = get_field('banner_image');
        if (!empty($banner)): ?>
            <div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
        <?php else: ?>
            <div class="banner default"></div>
        <?php endif; ?>
        <div class="container full-header">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <h1><?php the_title(); ?></h1>
                </div>
            </div>
        </div>

        <div class="container hidden-sm-down">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <?php if (function_exists('yoast_breadcrumb')) {
                    echo '<sub class="breadcrumbs-nav">Navigation</sub>';
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                } ?>
            </div>
        </div>

        <div class="container content location">

            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 map">
                <?php if (get_field('google_map') !== ''): ?>
                    <?php
                    $location = get_field('google_map');

                    if ($location !== '') { ?>

                        <div class="acf-map">
                            <div class="marker" data-lat="<?php echo $location['lat']; ?>"
                                 data-lng="<?php echo $location['lng']; ?>"></div>
                        </div>
                    <?php } ?>
                <?php endif; ?>
            </div>
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <h2><?php if (get_field('location_description_title') !== '') {
                        the_field('location_description_title');
                    } ?></h2>
                <?php the_field('location_description'); ?>

                <?php the_content(); ?>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <h2><?php if (get_field('location_address_title') !== '') {
                        the_field('location_address_title');
                    } ?></h2>
                <?php the_field('location_address'); ?>
                <hr>
                <?php if (get_field('office_phone_number')): ?>
                    <p>Phone Number: <strong><a
                                    href="tel: <?php the_field('office_phone_number'); ?>"><?php the_field('office_phone_number'); ?></a></strong>
                    </p>
                <?php endif; ?>
                <?php if (get_field('office_fax_number')): ?>
                    <p>Fax Number: <strong><?php the_field('office_fax_number'); ?></strong></p>
                <?php endif; ?>

                <?php dynamic_sidebar('theme-section-8'); ?>
            </div>
        </div>
    </div>

<?php
get_footer();
