<?php
/* Template Name: Our People */

$filter = false;
?>

<?php
get_header();
?>

<div class="full-rule">

    <?php
    $banner = get_field('banner_image');
    if (!empty($banner)): ?>
        <div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
    <?php else: ?>
        <div class="banner default"></div>
    <?php endif; ?>
    <div class="container full-header">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <h1><?php the_title(); ?></h1>
            </div>
        </div>
    </div>

    <div class="container hidden-sm-down">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <?php if (function_exists('yoast_breadcrumb')) {
                echo '<sub class="breadcrumbs-nav">Navigation</sub>';
                yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
            } ?>
        </div>
    </div>

    <div class="container content">

        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <?php the_content(); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">


                <?php
                    if($filter == true) {
                        $terms = get_terms(array(
                            'taxonomy'   => 'staff',
                            'hide_empty' => false,
                        ));
                        global $wp;
                        if (is_paged()) {
                            $current_url = home_url(add_query_arg(array(), $wp->request));
                            $current_url_parts = explode("page", $current_url);
                            $current_url = $current_url_parts[0];

                        } else {
                            $current_url = home_url(add_query_arg(array(), $wp->request)) . "/";
                        }
                    }
                ?>
                <?php if($filter == true): ?>
                <ul class="filter-list">
                    <li class="<?php if (empty($_GET['id'])) {
                        echo "active";
                    } ?>"><a href="<?php echo $current_url; ?>">All</a></li>
                    <?php
                    foreach ($terms as $key => $value): ?>
                        <li class="<?php if ($value->slug == $_GET['value']) {
                            echo "active";
                        } ?>">
                            <a href="<?php echo $current_url . "?value=" . $value->slug . '&id=' . $value->term_id ?>"><?php echo $value->name ?></a>
                        </li>
                    <?php endforeach; ?>

                </ul>
                <?php endif; ?>

                <div class="row staff">
                    <?php
                    $paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1;
                    if (isset($_GET['id'])) {
                        $args = array(
                            'post_type'      => 'staff',
                            'posts_per_page' => 12,
                            'paged'          => $paged,
//                            'tax_query'      => array(
//                                array(
//                                    'taxonomy' => 'staff',
//                                    'field'    => 'slug',
//                                    'terms'    => $_GET['value'],
//                                ),
//                            ),
                        );

                    } else {
                        $args = array(
                            'post_type'      => 'staff',
                            'posts_per_page' => 12,
                            'paged'          => $paged,
                            'order'          => 'ASC'
                        );
                    }
                    $query = new WP_Query($args);
                    if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>

                        <div class="col-lg-3 col-md-3 col-sm-4 col-xs-12 main-staff">

                            <img src="<?php the_field('photo'); ?>" alt="">
                            <h2><?php the_field('name'); ?></h2>
                            <strong><?php the_field('role'); ?></strong>

                            <?php
                            $bio = get_field('bio');
                            $bio = shorten_string($bio, 35);
                            ?>

                            <!--                            --><?php //the_field('bio'); ?>
<!--                            <a href="#" data-toggle="modal" data-target="#--><?php //echo $post->ID ?><!--">-->
<!--                                Find out more.-->
<!--                            </a>-->

                        </div>

<!--                        <div class="project-model modal fade" id="--><?php //echo $post->ID ?><!--" role="dialog"-->
<!--                             aria-hidden="true">-->
<!--                            <div class="modal-dialog" role="document">-->
<!--                                <div class="modal-content">-->
<!--                                    <div class="text-xs-center">-->
<!--                                        <img src="--><?php //the_field('photo'); ?><!--">-->
<!--                                        <h4>--><?php //the_field('name'); ?><!--</h4>-->
<!--                                    </div>-->
<!--                                    <div class="modal-body">-->
<!--                                        --><?php //the_field('full_bio'); ?>
<!--                                    </div>-->
<!--                                    <div class="modal-footer">-->
<!--                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close-->
<!--                                        </button>-->
<!--                                    </div>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        </div>-->

                        <?php
                    endwhile;
                    else:
                        /**
                         * -----------------------------------------------------
                         * If no testimonials, display this message.
                         */
                        echo '<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 no-staff"> ';
                        echo '<h2 > Looks like we\'re haven\'t got any staff setup right now.</h2>';
                        echo '</div>';
                    endif;
                    ?>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 pagination">
                        <?php
                        $big = 999999999; // need an unlikely integer
                        echo paginate_links(array(
                            'base'    => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                            'format'  => '?paged=%#%',
                            'current' => max(1, get_query_var('paged')),
                            'total'   => $query->max_num_pages
                        ));
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php
get_footer();
?>
