<?php
/**
 * The template for displaying all single posts.
 *
 * @link    https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package template
 */
get_header();
?>

    <div class="full-rule">

<?php
$banner = get_field('banner_image');
if (!empty($banner)): ?>
    <div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
<?php else: ?>
    <div class="banner default"></div>
<?php endif; ?>
<?php if (strlen(get_the_title()) > 36): ?>
    <div class="container full-header extra">
    <?php else: ?>
    <div class="container full-header">
<?php endif; ?>
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <h1><?php the_title(); ?></h1>
        </div>
    </div>
    </div>

    <div class="container content">
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 post">
                <a href="<?php the_permalink() ?>">
                    <?php if (has_post_thumbnail($post->ID)): ?>
                        <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)) ?>" class="featured">
                    <?php endif; ?>
                </a>

                <?php the_content(); ?>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 sidebar">
                <?php dynamic_sidebar('sidebar-1'); ?>
            </div>
        </div>

    </div>
    </div>
<?php
get_footer();
