module.exports = function(grunt) {

  // Project configuration.
  grunt.initConfig({
    pkg: grunt.file.readJSON('package.json'),
    watch: {
            sass: {
                // We watch and compile sass files as normal but don't live reload here
                files: ['scss/**/*.scss'],
                tasks: ['sass']
            }
        },

        sass: {
            options: {
                sourceMap: true
            },
            dev: {
                files: {
                    'css/style.css' : 'scss/app.scss',
                    'css/admin-menus.css' : 'scss/admin-menus.scss',
                    'css/font-awesome.css' : 'scss/font-awesome/font-awesome.scss'
                }
            }
        }
  });

  grunt.loadNpmTasks('grunt-sass'); //$ npm install --save-dev grunt-sass
  grunt.loadNpmTasks('grunt-contrib-watch');

  // Default task(s).
  grunt.registerTask('default', ['watch']);
  grunt.registerTask('scss', ['sass']);

};
