<?php
/**
 * template functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package template
 */

/**
 * INCLUDE THE BOOTSTRAP WALKER SCRIPT.
 */
require_once('bs4navwalker.php');

if ( ! function_exists( 'template_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function template_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on template, use a find and replace
	 * to change 'template' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'template', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'template' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'template_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif;
add_action( 'after_setup_theme', 'template_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function template_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'template_content_width', 640 );
}
add_action( 'after_setup_theme', 'template_content_width', 0 );

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * INSTALL A NEWER VERSION OF JQUERY INTO THE FRONT-END OF THIS THEME.
 */
if( !is_admin() ){
	wp_deregister_script('jquery');
	wp_register_script('jquery', (get_stylesheet_directory_uri() . '/js/jquery-2.1.1.js'), false, '');
	wp_enqueue_script('jquery');
}

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * INSTALL CUSTOM NAVIGATION AREAS.
 */
register_nav_menus( array(
	'primary' => __( 'Header Navigation', 'template' ),
	'copyright' => __( 'Copyright Navigation Bar', 'template' ),
	'footer' => __( 'Footer Navigation', 'template' ),
) );

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * INSTALL CUSTOM WIDGET AREAS.
 */
function template_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'template' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'template' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column One', 'srwaite' ),
		'id'            => 'srwaite-1',
		'description'   => esc_html__( 'Add content for Footer Column One Here', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column Two', 'srwaite' ),
		'id'            => 'srwaite-2',
		'description'   => esc_html__( 'Add content for Footer Column Two Here', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column Three', 'srwaite' ),
		'id'            => 'srwaite-3',
		'description'   => esc_html__( 'Add content for Footer Column Three Here', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column Four', 'srwaite' ),
		'id'            => 'srwaite-4',
		'description'   => esc_html__( 'Add content for Footer Column Four Here', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column Five', 'srwaite' ),
		'id'            => 'srwaite-5',
		'description'   => esc_html__( 'Add content for Footer Column Five Here', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column Six', 'srwaite' ),
		'id'            => 'srwaite-6',
		'description'   => esc_html__( 'Add content for Footer Column Six Here', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Navigation Section 1 Sidebar', 'srwaite' ),
		'id'            => 'srwaite-section-1',
		'description'   => esc_html__( 'Add content for Section 1 Sidebar', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Navigation Section 2 Sidebar', 'srwaite' ),
		'id'            => 'srwaite-section-2',
		'description'   => esc_html__( 'Add content for Section 2 Sidebar', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Navigation Section 3 Sidebar', 'srwaite' ),
		'id'            => 'srwaite-section-3',
		'description'   => esc_html__( 'Add content for Section 3 Sidebar', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Navigation Section 4 Sidebar', 'srwaite' ),
		'id'            => 'srwaite-section-4',
		'description'   => esc_html__( 'Add content for Section 4 Sidebar', 'srwaite' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h6 class="widget-title">',
		'after_title'   => '</h6>',
	) );
}
add_action( 'widgets_init', 'template_widgets_init' );

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * INSTALL CUSTOM CSS FILES AND JAVASCRIPT FILES.
 */
function srwaite_scripts() {
	wp_enqueue_style( 'srwaite-style', get_stylesheet_directory_uri() . '/css/style.css' );
	wp_enqueue_style ( 'srwaite-main-font', 'https://fonts.googleapis.com/css?family=Lato|Open+Sans:400,700' );
	wp_enqueue_style( 'srwaite-fontawesome', get_stylesheet_directory_uri() . '/css/font-awesome.css' );
	wp_enqueue_script( 'srwaite-bootstrap', get_stylesheet_directory_uri() . '/js/bootstrap/bootstrap.js', array('jquery'), false, true );
	wp_enqueue_script( 'srwaite-script', get_stylesheet_directory_uri() . '/js/script.js', array('jquery'), false, true );

	if ( is_front_page() ) {
		wp_enqueue_script( 'srwaite-slider', get_stylesheet_directory_uri() . '/js/slider.js', array('jquery'), false, true );
	}

	global $post;
	if ($post->post_name == 'srwaite.php'):
		// INSTALL POST RELEATED CONTENT IN A BLOCK LIKE THIS.
	endif;

	$template = get_post_meta($post->ID,'_wp_page_template',true);
	if ($template == 'default'):
		// IF TEMPLATE IS DEFAUT LOAD THIS EXTRA FONT.
//		wp_enqueue_style ( 'srwaite_title_font', 'https://fonts.googleapis.com/css?family=Lora:700' );
	elseif ($template == "page-location" . ".php"):
        wp_enqueue_script( 'google-map', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyAz-7psJd9tN9BTb9COzw9Rk-h88Q9rags', array(), '3', true );
        wp_enqueue_script( 'google-map-init', get_template_directory_uri() . '/js/acf_google_map.js', array('google-map', 'jquery'), '0.1', true );
    endif;

}
add_action( 'wp_enqueue_scripts', 'srwaite_scripts' );

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * INSTALL CUSTOM CSS FOR ADMIN PAGES.
 */
function template_scripts_admin() {
	if ($_GET['page'] == 'srwaite.php' || $_GET['page'] == 'theme_site_settings' || $_GET['page'] == 'theme_site_services_settings' || $_GET['page'] == 'theme_social_settings' || $_GET['page'] == 'theme_site_featured'):
		wp_enqueue_script( 'tecmark-admin-bootstrap', get_stylesheet_directory_uri() . '/js/bootstrap/bootstrap.js' );
		wp_enqueue_style ( 'tecmark-admin-menu-font', 'https://fonts.googleapis.com/css?family=Montserrat|Source+Sans+Pro' );
		wp_enqueue_style ( 'tecmark-admin-menu-styles', get_stylesheet_directory_uri() . '/css/admin-menus.css' );

		wp_enqueue_script( 'tecmark-admin-media', get_template_directory_uri() .'/js/upload.js', array('jquery') );
		wp_enqueue_media();
    	wp_enqueue_script( 'media-lib-uploader-js' );
	endif;

}
add_action('admin_enqueue_scripts', 'template_scripts_admin');

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * ADD A CUSTOM USER ROLE - CLIENT.
 */
 add_role( 'client', __(
 	'Client' ),
 	array(
 		'read' => true,
 		'edit_posts' => true,
 		'edit_pages' => true,
 		'edit_others_posts' => true,
 		'edit_published_posts' => true,
 		'edit_others_pages' => true,
 		'edit_published_pages' => true,
 		'create_posts' => true,
 		'manage_categories' => true,
 		'publish_posts' => true,
 		'manage_options' => true,
 		'delete_posts' => true,
 		'edit_themes' => true,
 		'edit_theme_options' => true,
 		'delete_others_pages' => true,
 		'delete_published_pages' => true,
 		'delete_private_posts' => true
 	)
 );

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * REGISTER THE CUSTOM SETTINGS PAGES.
 */
//
function setup_theme_admin_menus() {
	add_menu_page( 'Branding', 'Branding', 'manage_options', 'srwaite.php', 'theme_introduction_menu_init', null, 3);
	//               SLUG                 TITLE           MENU TITE        CAPABILITY        MENU SLUG              FUNCTION
	add_submenu_page('srwaite.php', 'Site Settings', 'Site Settings', 'manage_options', 'theme_site_settings', 'theme_settings_menu_init');
	add_submenu_page('srwaite.php', 'Featured Boxes', 'Featured Boxes', 'manage_options', 'theme_site_featured', 'theme_featured_menu_init');
	add_submenu_page('srwaite.php', 'Social Settings', 'Social Settings', 'manage_options', 'theme_social_settings', 'theme_social_menu_init');
	add_submenu_page('srwaite.php', 'Site Services', 'Site Services', 'manage_options', 'theme_site_services_settings', 'theme_services_menu_init');

}
add_action("admin_menu", "setup_theme_admin_menus");

// LOAD THEME MENU CONTENT //
function theme_introduction_menu_init() {
	require( get_template_directory() . '/inc/settings-introduction.php' );
    theme_introduction_menu_content();
}

function theme_settings_menu_init() {
	require( get_template_directory() . '/inc/settings-main.php' );
    theme_settings_menu_content();
}

function theme_featured_menu_init() {
	require( get_template_directory() . '/inc/settings-featured.php' );
    theme_featured_menu_content();
}

function theme_social_menu_init() {
	require( get_template_directory() . '/inc/settings-social.php' );
    theme_social_menu_content();
}

function theme_services_menu_init() {
	require( get_template_directory() . '/inc/settings-services.php' );
    theme_services_menu_content();
}

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * REGISTER CUSTOM SETTINGS FIELDS
 */
add_action("admin_init", "theme_settings_menu_fields");
add_action("admin_init", "theme_featured_menu_fields");
add_action("admin_init", "theme_services_menu_fields");
add_action("admin_init", "theme_social_menu_fields");

function theme_settings_menu_fields() {

    add_settings_section("theme_settings_options", "", null, "theme-options");
    //                 Field Name
    add_settings_field("company_name", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_tag", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_logo", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_logo_white", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_copyright", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_legal", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_address", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_contact_phone", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("company_contact_email", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("header_company_phone", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("header_compnay_email", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("footer_location_title", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("footer_contactform", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("footer_background", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("footer_logo", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");
    add_settings_field("header_contact_url", null, "theme_settings_menus_show_fields", "theme-options", "theme_settings_options");

	register_setting("theme_settings_options", "company_name");
	register_setting("theme_settings_options", "company_tag");
	register_setting("theme_settings_options", "company_logo");
	register_setting("theme_settings_options", "company_logo_white");
	register_setting("theme_settings_options", "company_address");
	register_setting("theme_settings_options", "company_contact_phone");
	register_setting("theme_settings_options", "company_contact_email");
	register_setting("theme_settings_options", "header_company_phone");
	register_setting("theme_settings_options", "header_company_email");
	register_setting("theme_settings_options", "company_copyright");
	register_setting("theme_settings_options", "company_legal");
	register_setting("theme_settings_options", "footer_location_title");
	register_setting("theme_settings_options", "footer_contactform");
	register_setting("theme_settings_options", "footer_background");
	register_setting("theme_settings_options", "footer_logo");
	register_setting("theme_settings_options", "header_contact_url");
}

function theme_services_menu_fields() {

    add_settings_section("theme_services_options", "", null, "theme-services");
    //                 Field Name
    add_settings_field("head_code", null, "theme_services_menus_show_fields", "theme-services", "theme_services_options");
    add_settings_field("tracking_code", null, "theme_services_menus_show_fields", "theme-services", "theme_services_options");
    add_settings_field("footer_code", null, "theme_services_menus_show_fields", "theme-services", "theme_services_options");
    add_settings_field("call-to-action", null, "theme_services_menus_show_fields", "theme-services", "theme_services_options");
    //               SECTION                   FIELD NAME
    register_setting("theme_services_options", "head_code");
    register_setting("theme_services_options", "tracking_code");
    register_setting("theme_services_options", "footer_code");
    register_setting("theme_services_options", "call-to-action");

}

function theme_social_menu_fields() {

    add_settings_section("theme_social_options", "", null, "theme-social");
    //                 Field Name
    add_settings_field("header_title", null, "theme_social_menus_show_fields", "theme-soical", "theme_social_options");
    add_settings_field("twitter_social", null, "theme_social_menus_show_fields", "theme-soical", "theme_social_options");
    add_settings_field("youtube_social", null, "theme_social_menus_show_fields", "soical-services", "theme_social_options");
    add_settings_field("linkin_social", null, "theme_social_menus_show_fields", "soical-services", "theme_social_options");
    add_settings_field("pintrest_social", null, "theme_social_menus_show_fields", "soical-services", "theme_social_options");
    add_settings_field("facebook_social", null, "theme_social_menus_show_fields", "soical-services", "theme_social_options");
    add_settings_field("spotify_social", null, "theme_social_menus_show_fields", "soical-services", "theme_social_options");
    add_settings_field("instagram_social", null, "theme_social_menus_show_fields", "soical-services", "theme_social_options");

    //               SECTION                   FIELD NAME
    register_setting("theme_social_options", "header_title");
    register_setting("theme_social_options", "twitter_social");
    register_setting("theme_social_options", "youtube_social");
    register_setting("theme_social_options", "linkin_social");
    register_setting("theme_social_options", "pintrest_social");
    register_setting("theme_social_options", "facebook_social");
    register_setting("theme_social_options", "spotify_social");
    register_setting("theme_social_options", "instagram_social");

}
function theme_featured_menu_fields() {

    add_settings_section("theme_featured_options", "", null, "theme-featured");
    //                 Field Name
    add_settings_field("featured_1_title", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_2_title", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_3_title", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_4_title", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_1_description", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_2_description", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_3_description", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_4_description", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_1_read_text", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_2_read_text", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_3_read_text", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_4_read_text", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_1_read_link", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_2_read_link", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_3_read_link", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    add_settings_field("featured_4_read_link", null, "theme_featured_menus_show_fields", "theme-featured", "theme_featured_options");
    //               SECTION                   FIELD NAME
    register_setting("theme_featured_options", "featured_1_title");
    register_setting("theme_featured_options", "featured_2_title");
    register_setting("theme_featured_options", "featured_3_title");
    register_setting("theme_featured_options", "featured_4_title");
    register_setting("theme_featured_options", "featured_1_description");
    register_setting("theme_featured_options", "featured_2_description");
    register_setting("theme_featured_options", "featured_3_description");
    register_setting("theme_featured_options", "featured_4_description");
    register_setting("theme_featured_options", "featured_1_read_text");
    register_setting("theme_featured_options", "featured_2_read_text");
    register_setting("theme_featured_options", "featured_3_read_text");
    register_setting("theme_featured_options", "featured_4_read_text");
    register_setting("theme_featured_options", "featured_1_read_link");
    register_setting("theme_featured_options", "featured_2_read_link");
    register_setting("theme_featured_options", "featured_3_read_link");
    register_setting("theme_featured_options", "featured_4_read_link");

}

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * CUSTOMISE THE READ MORE LINK TEXT AND CLASSES.
 */
function modify_read_more_link() {
	return '<a class="more-link pull-right" href="' . get_permalink() . '">Read More</a>';
}
add_filter( 'the_content_more_link', 'modify_read_more_link' );

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * CUSTOMISE THE OPTIONS WITHIN THE WYSIWYG EDITOR STYLES DROPDOWN.
 * Removes: Heading 1.
 */
function wpa_45815($arr){
	$arr['block_formats'] = 'Paragraph=p;Heading 2=h2;Heading 3=h3;Heading 4=h4;Heading 5=h5;Heading 6=h6;Preformed=pre;';
	return $arr;
}
add_filter('tiny_mce_before_init', 'wpa_45815');

/**
 * REMOVE THE EMOJI CODE FROM WORDPRESS & PAGE HEAD.
 */
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');

/**
 * REMOVE RECENT COMMENTS INLINE STYLE FROM PAGE HEAD.
 */
function remove_recent_comments_style() {
	global $wp_widget_factory;
	remove_action('wp_head', array($wp_widget_factory->widgets['WP_Widget_Recent_Comments'], 'recent_comments_style'));
}
add_action('widgets_init', 'remove_recent_comments_style');

/**
 * REMOVE THE ADMIN BAR INLINE CSS FROM THE PAGE HEAD.
 */
 add_action('get_header', 'remove_admin_login_header');
 function remove_admin_login_header() {
 	remove_action('wp_head', '_admin_bar_bump_cb');
 }
/**
 * ---------------------------------------------------------------------------------------------------------------------
 * ADVANCED CUSTOM FIELDS - GOOGLE MAP API KEY.
 */
function my_acf_google_map_api( $api ){

    $api['key'] = 'AIzaSyAz-7psJd9tN9BTb9COzw9Rk-h88Q9rags';

    return $api;

}

add_filter('acf/fields/google_map/api', 'my_acf_google_map_api');

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * HELPER FUNCTION - FIND POST/PAGE HIGHEST PARENT.
 */
function get_highest_most_parent($post) {
	if ($post->post_parent)	{
		$ancestors=get_post_ancestors($post->ID);
		$root=count($ancestors)-1;
		$parent = $ancestors[$root];
	} else {
		$parent = $post->ID;
	}
	return $parent = get_post($parent);
}
/**
 * ---------------------------------------------------------------------------------------------------------------------
 * HELPER FUNCTION - CUT A STRING AT A GIVEN POINT.
 */
function shorten_string($string, $target) {
    $retval = $string;

    $string = preg_replace('/(?<=\S,)(?=\S)/', ' ', $string);
    $string = str_replace("\n", " ", $string);
    $array = explode(" ", $string);

    if (count($array)<=$target) {
        $retval = $string;
    } else {
        array_splice($array, $target);
        $retval = implode(" ", $array)."...";
    }
    echo $retval;
}

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * DETECT IF THE CONTACT FORM HAS BEEN SUBMITTED.
 */
if (isset($_POST['contact-form'])) {
	// CHECK THAT THE WORDPRESS EMAIL IS SET TO: webforms@dpp-law.com FOR LIVE SITE
	// CHECK THAT THE WORDPRESS EMAIL IS SET TO: joe.curran@tecmark.co.uk FOR DEV SITE
	$message_feedback = array();
	date_default_timezone_set('Europe/London');
	$_POST['details']['timestamp'] = date("d-m-Y H:i:s");
	$message = $_POST['details'];
	$_SESSION['message'] = $_POST['details'];
	//	$email = get_option('company_contact_email');
	//	$email = "joe.curran@tecmark.co.uk";
	$email = "rogerposener@dpp-law.com";
	$headers = 'From: DPP Web Enquiries <donotreply@dpp-law.com>' . "\r\n";
	$body = "";
	foreach ($message as $key => $node) {
		$body = $body . ucfirst(strtolower($key)) . ": " . $node . "\r\n\r\n";
	}
	if (isset($message['Subject'])) {
		$subject = $message['Subject'];
	} else {
		if (isset($message['Expertise'])) {
			$subject = $message['Expertise'];
		} else {
			$subject = 'DPP Web Enquiry';
		}
	}
	$_SESSION['error']['responce'] = $responseKeys["success"];
	if (empty($_POST['details']['Email'])) {
		$_SESSION['error']['email'] = "Please enter an email address!";

		return false;

	} else {
		if (empty($_POST['details']['Name'])) {
			$_SESSION['error']['name'] = "Please enter your name!";
		} else {
			if (empty($_POST['checkbox_check'])) {
				$_SESSION['error']['send'] = "Sorry... Are you ready to send you message? Click check the box below!";

			} else {
				$message_feedback = array(
					'type'    => 'success',
					'message' => 'Your message was sent successfully.'
				);
				if (wp_mail($email, $subject . $date, $body, $headers)) {
					// show message send success
					$message_feedback = array(
						'type'    => 'success',
						'message' => 'Your message was sent successfully.'
					);
					uploadFTPXML($_POST['details']); // XML Version
					uploadFTP($_POST['details']); // JSON Version
				} else {
					// show message send error
					$message_feedback = array(
						'type'    => 'danger',
						'message' => 'Sorry, your message failed to send. Please try again.'
					);
				}
			}
		}
	}
}
/**
 * ---------------------------------------------------------------------------------------------------------------------
 * CONVERT AN ARRAY TO XML.
 */
function array2xml($array, $xml = false) {

	if ($xml === false) {
		$xml = new SimpleXMLElement('<result/>');
	}
	foreach ($array as $key => $value) {
		if (is_array($value)) {
			array2xml($value, $xml->addChild($key));
		} else {
			$xml->addChild($key, $value);
		}
	}

	return $xml->asXML();
}

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * UPLOAD ALL CONTACT FORM SUBMISSIONS TO SERVER VIA FTP USING XML.
 *
 * @param $var
 */
function uploadFTPXML($details) {

	$date_y = date("Y"); // Year
	$date_m = date("m"); // Month
	$date_d = date("d"); // Day
	$date_path = $date_y . '/' . $date_m . '/' . $date_d . '/';
	$data = array2xml($details); // Message as XML
	$filename = str_replace(" ", "_", str_replace(":", "-", $details['timestamp']));
	$tmp = "./wp-content/uploads/contact-form/" . $date_path . $filename . ".xml"; // Path to save tmp file.
	if (!file_exists('./wp-content/uploads/contact-form/' . $date_path)) {
		mkdir('./wp-content/uploads/contact-form/' . $date_path, 0777, true);
	}
	file_put_contents($tmp, $data);
	/**
	 * Access FTP and Upload File
	 */
	$host = '62.133.30.59';
	$usr = 'Ftpuser';
	$pwd = 'Anfield1892$';
	$local_file = $tmp;
	$ftp_path = '/tecmark/contact-form/vincentcurley/' . $filename . '.xml';
	$conn_id = ftp_connect($host, 21);
	if (ftp_login($conn_id, $usr, $pwd)) {
		/**
		 * Upload the file
		 */
		$upload = ftp_put($conn_id, $ftp_path, $local_file, FTP_ASCII);
		if (!$upload) {
			echo "Error: Cannot upload XML";
		}
	} else {
		echo("Cannot login");

	}
	ftp_close($conn_id);
}

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * UPLOAD ALL CONTACT FORM SUBMISSIONS TO SERVER VIA FTP USING JSON.
 *
 * @param $var
 */
function uploadFTP($details) {

	$date_y = date("Y"); // Year
	$date_m = date("m"); // Month
	$date_d = date("d"); // Day
	$date_path = $date_y . '/' . $date_m . '/' . $date_d . '/';
	/**
	 * Save JSON to File
	 */
	$data = json_encode($details); // Message as JSON
	$filename = str_replace(" ", "_", str_replace(":", "-", $details['timestamp']));
	$tmp = "./wp-content/uploads/contact-form/" . $date_path . $filename . ".json"; // Path to save tmp file.
	if (!file_exists('./wp-content/uploads/contact-form/' . $date_path)) {
		mkdir('./wp-content/uploads/contact-form/' . $date_path, 0777, true);
	}
	file_put_contents($tmp, $data);
	/**
	 * Access FTP and Upload File
	 */
	//	$host = '62.133.30.59';
	//	$usr = 'Ftpuser';
	//	$pwd = 'Anfield1892$';
	//
	//	$local_file = $tmp;
	//	$ftp_path = '/tecmark/contact-form/vincentcurley/'. $date_path . $filename . '.json';
	//
	//	$conn_id = ftp_connect($host, 21);
	//
	//	if (ftp_login($conn_id, $usr, $pwd)) {
	//
	//		/**
	//		 * Check if the folders are ready to be accessed.
	//		 */
	//		function ftp_mksubdirs($ftpcon,$ftpbasedir,$ftpath){
	//			@ftp_chdir($ftpcon, $ftpbasedir);
	//			$parts = explode('/',$ftpath);
	//			foreach($parts as $part){
	//				if(!@ftp_chdir($ftpcon, $part)){
	//					ftp_mkdir($ftpcon, $part);
	//					ftp_chdir($ftpcon, $part);
	//				}
	//			}
	//		}
	//
	//		$path_of_storage = '/tecmark/contact-form/';
	//		ftp_mksubdirs($conn_id,$path_of_storage,$date_path);
	//
	//		/**
	//		 * Upload the file
	//		 */
	//
	//		$upload = ftp_put($conn_id, $ftp_path, $local_file, FTP_ASCII);
	//
	//		if (!$upload) {
	//			echo "Error: Cannot upload JSON";
	//		}
	//	} else {
	//		die("Cannot login");
	//	}
	//	ftp_close($conn_id);
}


/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
