<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link    https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package template
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <link rel="apple-touch-icon" sizes="57x57" href="/wp-content/themes/cips-training/icons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="/wp-content/themes/cips-training/icons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="/wp-content/themes/cips-training/icons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="/wp-content/themes/cips-training/icons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="/wp-content/themes/cips-training/icons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="/wp-content/themes/cips-training/icons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="/wp-content/themes/cips-training/icons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="/wp-content/themes/cips-training/icons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="/wp-content/themes/cips-training/icons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"
          href="/wp-content/themes/cips-training/icons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/wp-content/themes/cips-training/icons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="/wp-content/themes/cips-training/icons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/wp-content/themes/cips-training/icons/favicon-16x16.png">
    <link rel="manifest" href="/wp-content/themes/cips-training/icons/manifest.json">
    <meta name="msapplication-TileColor" content="#3e3c79">
    <meta name="msapplication-TileImage" content="/wp-content/themes/cips-training/icons/ms-icon-144x144.png">
    <meta name="theme-color" content="#3e3c79">

    <?php wp_head(); ?>
    <?php echo get_option('head_code'); ?>
    <?php echo get_option('tracking_code'); ?>
</head>

<body <?php body_class(); ?>>
<header>
    <div class="details hidden-md-down">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <p class="phone"><a
                                href="tel:<?php echo get_option('company_contact_phone') ?>"><?php echo get_option('header_company_phone'); ?> <?php echo get_option('company_contact_phone') ?></a>
                    </p>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <p class="email"><a
                                href="mailto: <?php echo get_option('company_contact_email') ?>"><?php echo get_option('header_company_email'); ?> <?php echo get_option('company_contact_email') ?></a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <div class="logo">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">

                    <?php if (get_option('company_logo') !== ''): ?>
                        <a href="/">
                            <img src="<?php echo get_option('company_logo'); ?>"
                                 alt="<?php echo get_option('company_name'); ?>">
                        </a>
                    <?php endif; ?>
                    <?php if (get_option('company_tag') !== ''): ?>
                        <p class="tagline"><?php echo get_option('company_tag'); ?></p>
                    <?php endif; ?>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 connections">
                    <?php $header = 2;
                    include('inc/_social_media_icons.php'); ?>
                    <a class="new-line" href="<?php echo get_option('header_contact_url') ?>"><i class="fa fa-envelope" aria-hidden="true"></i> <?php echo get_option('header_company_email'); ?></a>

                    <a class="new-line" href="tel:<?php echo get_option('company_contact_phone') ?>"><i class="fa fa-phone" aria-hidden="true"></i> <?php echo get_option('header_company_phone'); ?> <?php echo get_option('company_contact_phone') ?></a>

                </div>
            </div>
        </div>
    </div>
    <div class="navigation">
        <ul class="nav navbar-nav">
            <?php
            wp_nav_menu(['menu' => 'primary', 'theme_location' => 'primary', 'container' => 'div', 'container_id' => 'bs-navbar', 'container_class' => 'navbar-collapse', 'menu_id' => false, 'menu_class' => 'nav navbar-nav', 'depth' => 2, //'fallback_cb'     => 'bs4navwalker::fallback',
                //'walker'          => new bs4navwalker()
            ]);
            ?>
        </ul>
    </div>
</header>
<?php //Menu Push Down // ?>
<div class="menu-push">
    <div class="menu-padding"></div>
</div>

