<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package template
 */

get_header(); ?>

<div class="full-rule">
	<?php
	$banner = get_field('banner_image');
	if (!empty($banner)): ?>
		<div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
	<?php else: ?>
		<div class="banner default"></div>
	<?php endif; ?>
	<div class="container full-header">
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
				<h1><?php echo get_the_title(get_option('page_for_posts')) ?></h1>
			</div>
		</div>
	</div>


	<div class="container content">

		<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
			<?php if( is_home() ) :
				global $query_string;
				$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				query_posts(array('posts_per_page'=> 8,'paged'=>$paged ));
				?>

			<?php endif;?>

			<?php

			if (have_posts()) : while (have_posts()) : the_post(); ?>

				<article class="post line">
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 post blog-list">
						<a href="<?php the_permalink() ?>">
							<?php if (has_post_thumbnail($post->ID)): ?>
								<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id($post->ID)) ?>">
							<?php endif; ?>
							<h3><?php the_title(); ?></h3>
						</a>
						<?php the_content() ?>
					</div>
				</article>
				<?php
			endwhile;
				the_posts_pagination( array(
					'mid_size'           => 2,
					'prev_text'          => __( 'Previous', '' ),
					'next_text'          => __( 'Next', '' ),
					'screen_reader_text' => 'More Articles',
				) );
			endif;
			?>

	    </div>
        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 sidebar hidden-md-down">
            <?php dynamic_sidebar('cips-training-section-1'); ?>
        </div>

</div>

<?php
get_footer();
