<?php
/* Template Name: Locations Listing */
?>
<?php
get_header();
?>

    <div class="full-rule">

        <?php
        $banner = get_field('banner_image');
        if (!empty($banner)): ?>
            <div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
        <?php else: ?>
            <div class="banner default"></div>
        <?php endif; ?>
        <div class="container full-header">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <h1><?php the_title(); ?></h1>
                </div>
            </div>
        </div>

        <div class="container hidden-sm-down">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <?php if (function_exists('yoast_breadcrumb')) {
                    echo '<sub class="breadcrumbs-nav">Navigation</sub>';
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                } ?>
            </div>
        </div>

        <div class="container content">

            <div class="col-lg-8 col-md-12 col-sm-12 col-xs-12">

                <?php the_content(); ?>

                <div class="row">

                    <?php

                        $locations = get_field('locations');
                        foreach ($locations as $location): ?>

                            <div class="col-lg-6 col-md-12 col-sm-12 location">
                                <a href="<?php echo $location['link']; ?>">
                                    <div class="image">
                                        <div class="overlay">
                                            <div class="inner">
                                                <span>View Location</span>
                                            </div>
                                        </div>
                                        <img src="<?php echo $location['image_static_map']; ?>" alt="<?php echo $location['name'] ?>">
                                    </div>
                                    <h2><?php echo $location['name']; ?></h2>
                                    <?php if ($location['content']): ?>

                                        <div class="list-content">
                                            <?php echo $location['content']; ?>
                                        </div>

                                    <?php endif; ?>
                                </a>
                            </div>

                    <?php
                        endforeach;
                    ?>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 sidebar">
                <?php dynamic_sidebar('cips-training-section-1'); ?>
            </div>

        </div>
    </div>

<?php
get_footer();
