<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package template
 */

get_header(); ?>

<div class="full-rule">

	<?php
	$banner = get_field('banner_image');
	if (!empty($banner)): ?>
		<div class="banner" style="background-image: url(<?php the_field('banner_image'); ?>);"></div>
	<?php else: ?>
		<div class="banner default"></div>
	<?php endif; ?>
	<?php if (strlen(get_the_title()) > 48): ?>
		<div class="container full-header extra">
		<?php else: ?>
		<div class="container full-header">
	<?php endif; ?>
		    <div class="row">
				<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
			        <h1><?php the_title(); ?></h1>
				</div>
		    </div>
		</div>

	<div class="container hidden-sm-down">
	    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
			<?php if ( function_exists('yoast_breadcrumb') ) {
				echo '<sub class="breadcrumbs-nav">Navigation</sub>';
				yoast_breadcrumb('<p id="breadcrumbs">','</p>');
			} ?>
	    </div>
	</div>

	<div class="container content">

		<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
		    <?php the_content(); ?>
		</div>

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 call-to-action-content">
            <?php echo get_option('call-to-action'); ?>
        </div>

	</div>
</div>

<?php
get_footer();
