/**
 * Handle the mobile menu. 
 * Hamburger open/close & menus opens and closes.
 */
window.addEventListener("DOMContentLoaded", () => {
    const body = document.querySelector('body');
    const header = document.querySelector('header');
    if (header !== null && header !== undefined) {
        const hamburger = document.querySelector('.hamburger input');
        
        if (hamburger !== null && hamburger !== undefined) {
            hamburger.addEventListener('change', () => {
                if (hamburger.checked == true) {
                    body.dataset.menuState = "1";
                    header.dataset.menuState = "1";
                } else {
                    body.dataset.menuState = "0";
                    header.dataset.menuState = "0";
                    const menuItemsWithChildren = document.querySelectorAll('li.menu-item-has-children');
                    menuItemsWithChildren.forEach((element) => {
                        element.dataset.state = "0";
                    });
                }
            });
        }
    }

    const menu = document.querySelector('[data-menu="mobile-menu"]');
    if (menu !== null && menu !== undefined) {
        const menuLinks = menu.querySelectorAll('li');

        // For each link.
        menuLinks.forEach((element) => {
            // Prevent empty links reloading the page.
            const link = element.querySelector('a');
            if (link.href == "#") {
                link.addEventListener("click", (event) => {
                    event.preventDefault();
                })
            }

            if (element.classList.contains('menu-item-has-children')) {

                // Add a state data value.
                element.dataset.state = 0;

                // Add the sub menu trigger element.
                let trigger = document.createElement("span");
                element.appendChild(trigger);

                // Add a click event to the tirgger element.
                trigger.addEventListener('click', () => {
                    if (element.dataset.state == "0")
                        element.dataset.state = "1";
                    else
                        element.dataset.state = "0";
                });

                // Add a sub menu close elements to all sub menus.
                const subMenus = element.querySelectorAll('ul.sub-menu');
                subMenus.forEach((subMenu) => {

                    if (subMenu.parentNode.parentNode.classList.contains('menu')) {
                        // Create the element for the menu list.
                        let closeTrigger = document.createElement('li');
                        closeTrigger.classList.add('menu-item', 'section-title');
                        
                        closeTrigger.addEventListener('click', () => {
                            closeTrigger.parentNode.parentNode.dataset.state = "0";
                        });
                        
                        // Add the new element to the menu list.
                        subMenu.prepend(closeTrigger);
                    }
                    
                });

            }
        });
    }
});



// Header Scroll Detection
// window.addEventListener('load', () => {
//     if (document.querySelector('header[data-scrolled]')) {
//         const header = document.querySelector('header[data-scrolled]');
//         let prev = 0;

//         if (window.scrollY > 1)
//             header.dataset.scrolled = "1"

//         window.addEventListener('scroll', () => {
//             const header = document.querySelector('header[data-scrolled]');

//             if (window.scrollY > 100) {
//                 header.dataset.scrolled = "1"
//             } else {
//                 header.dataset.scrolled = "0"
//             }
//             prev = window.scrollY;
//         });
//     }
// });




/**
 * Accordions.
 */
window.addEventListener("load", () => {
    let accordionGroups = document.querySelectorAll('[data-accordion]');
    if (accordionGroups !== null && accordionGroups !== undefined) {
        accordionGroups.forEach((group) => {
            let closeAll = (group.hasAttribute('close-all')) ? true : false;

            let rows = group.querySelectorAll('[data-accordion-target]');
            rows.forEach((row) => {
                row.addEventListener('click', (e) => {
                    e.preventDefault();

                    if (closeAll) {
                        if (row.hasAttribute("expanded")) {
                            row.removeAttribute("expanded");
                            row.setAttribute("aria-expanded", false);
                            document.querySelector(row.dataset.accordionTarget).removeAttribute("expanded");
                        } else {
                            rows.forEach((row) => {
                                row.removeAttribute("expanded");
                                row.setAttribute("aria-expanded", false);
                                row.parentNode.parentNode.querySelector('.body').removeAttribute("expanded");
                            });
                            row.setAttribute("expanded", true);
                            row.setAttribute("aria-expanded", true);
                            document.querySelector(row.dataset.accordionTarget).setAttribute("expanded", true);
                        }
                    } else {

                        // Expand or close row
                        if (row.hasAttribute("expanded")) {
                            row.removeAttribute("expanded");
                            row.setAttribute("aria-expanded", false);
                            document.querySelector(row.dataset.accordionTarget).removeAttribute("expanded");
                        } else {
                            row.setAttribute("expanded", true);
                            row.setAttribute("aria-expanded", true);
                            document.querySelector(row.dataset.accordionTarget).setAttribute("expanded", true);
                        }
                    }

                });
            });
        });
    }
});



/**
 * Responsive tables.
 */
window.addEventListener("load", () => {
    const tables = document.querySelectorAll('table');

    tables.forEach((table, index) => {

        if (table.dataset.table === "responsive")
            return;
        else
            table.dataset.table = "responsive";

        const rows = table.querySelectorAll('tr');
        const cellsPerRow = rows[0].childElementCount; 

        // Get Titles
        let titles = [];
        let titleCells = rows[0].querySelectorAll('td');
        if (titleCells.length === 0) {
            titleCells = rows[0].querySelectorAll('th');
        }
        titleCells.forEach((cell, index) => {
            if (cell.childElementCount === 0) {
                titles[index] = cell.innerHTML;
            } else {
                titles[index] = cell.innerHTML.replace(/(<([^>]+)>)/ig, "");
            }
        });

        // For each row
        rows.forEach((row, index) => {
            var empty = 0;

            if (index === 0)
                return;

            // Find Cells 
            const cells = row.querySelectorAll('td');
            cells.forEach((cell, index) => {

                // Find empty cells.
                if (cell.innerHTML == "&nbsp;") 
                    cell.innerHTML = "";
                
                if (cell.children.length === 0 && cell.innerHTML.length === 0) {
                    cell.classList.add('column-empty');
                    empty++;
                }

                let label = document.createElement('span');
                label.classList.add('column-title')
                label.innerHTML = titles[index];
                cell.prepend(label);
            });

            // Remove empty rows.
            if (empty === cellsPerRow)
                row.remove();
        });
    })
});



/**
 *  Google Maps.
 */
// (function($) {

//     /**
//      * initMap
//      *
//      * Renders a Google Map onto the selected jQuery element
//      *
//      * @date    22/10/19
//      * @since   5.8.6
//      *
//      * @param   jQuery $el The jQuery element.
//      * @return  object The map instance.
//      */
//     function initMap($el) {

//         // Find marker elements within map.
//         var $markers = $el.find('.marker');

//         // Create gerenic map.
//         var mapArgs = {
//             zoom: $el.data('zoom') || 13,
//             mapTypeId: google.maps.MapTypeId.ROADMAP,
//             disableDefaultUI: false,
//         };
//         var map = new google.maps.Map($el[0], mapArgs);

//         // Add markers.
//         map.markers = [];
//         $markers.each(function() {
//             initMarker($(this), map);
//         });

//         // Center map based on markers.
//         centerMap(map);

//         // Return map instance.
//         return map;
//     }

//     /**
//      * initMarker
//      *
//      * Creates a marker for the given jQuery element and map.
//      *
//      * @date    22/10/19
//      * @since   5.8.6
//      *
//      * @param   jQuery $el The jQuery element.
//      * @param   object The map instance.
//      * @return  object The marker instance.
//      */
//     function initMarker($marker, map) {

//         // Get position from marker.
//         var lat = $marker.data('lat');
//         var lng = $marker.data('lng');
//         var latLng = {
//             lat: parseFloat(lat),
//             lng: parseFloat(lng)
//         };

//         // Create marker instance.
//         var marker = new google.maps.Marker({
//             position: latLng,
//             map: map
//         });

//         // Append to reference for later use.
//         map.markers.push(marker);

//         // If marker contains HTML, add it to an infoWindow.
//         if ($marker.html()) {

//             // Create info window.
//             var infowindow = new google.maps.InfoWindow({
//                 content: $marker.html()
//             });

//             // Show info window when marker is clicked.
//             google.maps.event.addListener(marker, 'click', function() {
//                 infowindow.open(map, marker);
//             });
//         }
//     }

//     /**
//      * centerMap
//      *
//      * Centers the map showing all markers in view.
//      *
//      * @date    22/10/19
//      * @since   5.8.6
//      *
//      * @param   object The map instance.
//      * @return  void
//      */
//     function centerMap(map) {

//         // Create map boundaries from all map markers.
//         var bounds = new google.maps.LatLngBounds();
//         map.markers.forEach(function(marker) {
//             bounds.extend({
//                 lat: marker.position.lat(),
//                 lng: marker.position.lng()
//             });
//         });

//         // Case: Single marker.
//         if (map.markers.length == 1) {
//             map.setCenter(bounds.getCenter());

//             // Case: Multiple markers.
//         } else {
//             map.fitBounds(bounds);
//         }
//     }

//     // Render maps on page load.
//     $(document).ready(function() {
//         $('.acf-map').each(function() {
//             var map = initMap($(this));
//         });
//     });

// })(jQuery);



// Ninja Forms - Custom Validation
document.addEventListener('DOMContentLoaded', function () {

    if (typeof Marionette != "undefined") {
        var myCustomFieldController = Marionette.Object.extend({
            initialize: function(options) {
                
                // On the Form Submission's field validaiton…
                var submitChannel = Backbone.Radio.channel( 'submit' );
                this.listenTo(submitChannel, 'validate:field', this.validate);
                
                // on the Field's model value change…
                var fieldsChannel = Backbone.Radio.channel( 'phone' );
                this.listenTo(fieldsChannel, 'change:modelValue', this.validatePhone); 

                // Listen to the render:view event for a field type. Example: Textbox field.
                this.listenTo( nfRadio.channel( 'listselect' ), 'render:view', this.renderCustomSelect );

                this.listenTo( nfRadio.channel( 'number' ), 'render:view', this.renderCustomNumber );


            },

            validatePhone: function(model) {
                
                // Check if this is a phone number
                if (model.get('type') == "phone" && model.get('value')) {

                    var value = model.get('value');
                    var regex = new RegExp(/^(?:(?:\(?(?:0(?:0|11)\)?[\s-]?\(?|\+)44\)?[\s-]?(?:\(?0\)?[\s-]?)?)|(?:\(?0))(?:(?:\d{5}\)?[\s-]?\d{4,5})|(?:\d{4}\)?[\s-]?(?:\d{5}|\d{3}[\s-]?\d{3}))|(?:\d{3}\)?[\s-]?\d{3}[\s-]?\d{3,4})|(?:\d{2}\)?[\s-]?\d{4}[\s-]?\d{4}))(?:[\s-]?(?:x|ext\.?|\#)\d{3,4})?$/);
                    if (regex.test(value)) {
                        var modelID       = model.get( 'id' );
                        var errorID       = 'unvalid-phone';
                        var fieldsChannel = Backbone.Radio.channel( 'fields' );
                        fieldsChannel.request( 'remove:error', modelID, errorID );
                    } else {
                        var modelID       = model.get( 'id' );
                        var errorID       = 'unvalid-phone';
                        var errorMessage  = 'Please enter a valid UK phone number.';
                        var fieldsChannel = Backbone.Radio.channel( 'fields' );
                        fieldsChannel.request('add:error', modelID, errorID, errorMessage);
                    }
                    
                }

            },

            renderCustomNumber: function(field) {
                field.el.querySelector('input').setAttribute('pattern', '\\d*');
            },

            renderCustomSelect: function( view ) {

                // Add class to to field wrap.
                view.el.classList.add("custom-select");

                // Get the select field.
                var field = view.el.querySelector('select');
                field.classList.add('custom-select--original');

                // Create the basic dropdown.
                var dropdown = document.createElement('div');
                dropdown.classList.add('custom-select--options');

                // Current Label
                var label = document.createElement('div');
                label.classList.add('custom-select--label');
                label.innerHTML = field.options[field.selectedIndex].innerText;
                dropdown.appendChild(label);

                // For each option, create new element.
                var optionsGroup = document.createElement('div');
                optionsGroup.classList.add('custom-select--options-group');
                
                var options = view.el.querySelector('select').options;
                for (let i = 0; i < options.length; i++) {
                    const element = options[i];

                    // Create the element.
                    var customOptions = document.createElement('span');
                    customOptions.classList.add('custom-select--option');
                    customOptions.innerHTML = element.innerText;
                    customOptions.setAttribute('data-value', element.value)
                    
                    // Add to parent list.
                    optionsGroup.appendChild(customOptions);
                } 
                dropdown.appendChild(optionsGroup);

                var customOptions = optionsGroup.childNodes;
                for (let i = 0; i < customOptions.length; i++) {
                    const element = customOptions[i];
                    
                    element.addEventListener('click', function() {
                        jQuery( '#' + field.id ).val( element.dataset.value ).trigger( 'change' );
                        label.innerHTML = element.innerHTML;
                        view.el.querySelector('.custom-select--options').classList.remove('custom-select--active');
                    });
                    document.addEventListener('mouseup', function(e) {
                        if (!e.target.classList.contains("custom-select--options")) {
                            view.el.querySelector('.custom-select--options').classList.remove('custom-select--active');
                        }
                    });
                }

                // Append the custom dropdown.
                view.el.appendChild(dropdown);

                // Listen for click event on the label.
                view.el.querySelector('.custom-select--label').addEventListener('click', function() {
                    view.el.querySelector('.custom-select--options').classList.add('custom-select--active');
                });
            }

        });
        new myCustomFieldController();
    }

}, false);



/**
 * Animations on Enter View
 * Add data-animate="" to an element
 * https://github.com/new-data-services/tailwindcss-animated#readme
 */
document.addEventListener('DOMContentLoaded', () => {
    inView('[data-animate]')
        .on('enter', el => {
            el.classList.add(...el.dataset.animate.split(" "));
        })
});