<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background["colour"]);

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Set button alignment.
$buttonAlignment = "justify-start lg:justify-start";

// Change value when aligned center.
if ($textAlignment == "text-center") {
    $buttonAlignment = "justify-center lg:justify-center";
}

// Change value when aligned right.
if ($textAlignment == "text-right") {
    $buttonAlignment = "justify-center lg:justify-end";
}

?>

<section class="py-8 lg:py-10 px-6 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto">
        <div class="border border-smoke border-solid bg-white text-black flex flex-wrap items-center <?php echo (get_sub_field('media_side') == "left") ? "flex-col-reverse lg:flex-row-reverse" : "flex-col lg:flex-row"; ?> animate" data-animate="animate-fade-up">
            <div class="w-full lg:w-1/2 px-6 pb-6 <?php echo (get_sub_field('media_side') == "left") ? "md:pl-10" : "md:pr-10"; ?>">
                <?php if (!empty(get_sub_field('section_title'))) : ?>
                    <div class="flex items-center gap-6 mb-6">
                        <span class="h-[1px] bg-primary w-10"></span>
                        <?php render_title(get_sub_field('section_title'), get_sub_field('title_type'), 'font-normal text-primary text-sm uppercase mb-0', 'animate-fade-up'); ?>
                    </div>
                <?php endif; ?>
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'), trim('' . $titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'text-sm lg:text-base'); ?>
                <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex flex-wrap mt-6 " . $buttonAlignment,
                ]); ?>
            </div>
            <div class="w-full lg:w-1/2 mb-10 lg:mb-0">
                <?php render_image(get_sub_field('image'), 'square-large', true, 'object-cover w-full h-full'); ?>
            </div>
        </div>
    </div>
</section>