<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background["colour"]);

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Set button alignment.
$buttonAlignment = "justify-start md:justify-start";

// Change value when aligned center.
if ($textAlignment == "text-center") {
    $buttonAlignment = "justify-center md:justify-center";
}

// Change value when aligned right.
if ($textAlignment == "text-right") {
    $buttonAlignment = "justify-center md:justify-end";
}

?>

<div class="py-8 md:py-10 px-6 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container flex flex-col <?php echo (get_sub_field('media_side') == "left") ? "md:flex-row" : "md:flex-row-reverse"; ?>">

        <div class="w-full md:w-6/12 mb-4 md:mb-0 animate" data-animate="animate-fade-up animate-delay-1000">
            <?php render_image(get_sub_field('image'), array(690, 690), true, 'object-cover w-full h-full'); ?>
        </div>
        <div class="w-full md:w-6/12 <?php echo (get_sub_field('media_side') == "left") ? "md:pl-10" : "md:pr-10"; ?> flex flex-col justify-center animate" data-animate="animate-fade-up animate-delay-500">
            <?php if (!empty(get_sub_field('section_title'))) : ?>
                <div class="flex items-center gap-6 mb-6">
                    <span class="h-[1px] bg-primary w-10"></span>
                    <?php render_title(get_sub_field('section_title'), get_sub_field('title_type'), 'font-normal text-primary text-sm uppercase mb-0', 'animate-fade-up'); ?>
                </div>
            <?php endif; ?>
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'), trim('' . $titleFont . $titleStyle)); ?>
            <?php render_content(get_sub_field('content'), 'text-sm lg:text-base'); ?>
            <?php render_buttons([
                "buttons" => get_sub_field('clone_buttons', 'option'),
                "wrapClass" => "flex flex-wrap mt-6 " . $buttonAlignment,
            ]); ?>
        </div>

    </div>
</div>