<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background["colour"]);

?>

<div class="relative overflow-hidden md:min-h-[26rem] aspect-[25/13] md:aspect-auto flex items-center justify-center px-6 py-10 <?php echo $textColour; ?> <?php echo $background["colour"]; ?>">

    <?php if (!empty($background['imageUrl'])) : ?>
        <img src="<?php echo $background['imageUrl']; ?>" alt="<?php echo $background['alt']; ?>" class="z-10 absolute top-0 left-0 object-cover object-center w-full h-full select-none">
    <?php endif; ?>

    <?php if (get_sub_field('enable_video_background')) : ?>
        <div class="absolute top-0 left-0 w-full h-full z-10">
            <video id="video-<?php echo $position; ?>" autoplay muted loop playsinline reload="auto" poster="<?php echo (!empty($background['imageUrl'])) ? $background['imageUrl'] : ""; ?>" class="w-full h-full object-cover">
                <source src="<?php echo get_sub_field('video_background_url'); ?>" type="video/mp4">
            </video>
        </div>
    <?php endif; ?>

    <?php if (get_sub_field('enable_video_background_muting')) : ?>
        <div class="absolute left-0 top-0 w-full h-full bg-black <?php echo get_sub_field('background_muting_transparency'); ?> z-20 select-none"></div>
    <?php endif; ?>

    <div class="container mx-auto w-full h-full relative z-30 flex flex-col justify-center py-20 <?php echo get_sub_field('hide_content') == true ? "hidden" : ""; ?>">
        <?php render_title(get_sub_field('title'), get_sub_field('title_type'), null, 'animate-fade-up'); ?>
        <?php render_content(get_sub_field('content'), 'max-w-lg', 'text-lg', 'animate-fade-up animate-delay-[200ms]'); ?>
        <?php render_buttons([
            "buttons" => get_sub_field('clone_buttons', 'option'),
            "wrapClass" => "flex mt-6 md:mt-10",
            "animate" => "animate-fade-up animate-delay-[500ms]"
        ]); ?>

    </div>
</div>