<?php

/**
 * ----- ----- -----
 * Include Helper Functions
 * ----- ----- -----
 */
view('blog/_helpers', null, true);

// Access the requires container variable. 
global $container;

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Get the selected category.
$categoryID = get_sub_field('category');
$category = get_term_by('term_id', $categoryID, 'category');

// Get the posts.
$args = array(
    'posts_per_page' => 4,
    'post_type' => 'post',
    'post_status' => 'publish',
    'cat' => $categoryID,
    'orderby' => 'date',  // Order by date
    'order' => 'DESC'   // Newest first
);
$posts = new WP_Query($args);

// Get options to pass to the post-{template} views.
$args = ["blocks" => true];

wp_reset_postdata();
?>

<div class="relative pt-10 md:pt-20 px-6 <?php echo $background["colour"]; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>

    <?php if ($container) : ?>
        <div class="container mx-auto flex flex-wrap border-b border-smoke border-solid pb-6">
        <?php endif; ?>

        <div class="w-full flex flex-wrap items-center justify-between border-b border-smoke border-solid py-4 mb-6">
            <div>
                <?php render_title($category->name, 'h2', implode(" mb-0 ", [$titleFont, $titleStyle])); ?>
            </div>
            <div>
                <?php 
                render_buttons([
                    "buttons" => array(
                        array(
                            "link" => array(
                                "url" => get_term_link($category),
                                "title" => __('View all', 'tangobet') . " " . $category->name
                            ),
                            "style" => "keyline",
                            "colour" => "black"
                        )
                    ),
                    "wrapClass" => "mt-4 md:mt-0",
                    "remove_class" => "mb-2 mb-4",
                ]);
                ?>
            </div>
        </div>

        <div class="w-full md:w-1/2 md:pr-4">
            <?php
            if ($posts->have_posts()) {
                while ($posts->have_posts()) {
                    $posts->the_post();
                        view('blog.post-featured', null, null, $args);

                    break;
                }
            }
            ?>
        </div>
        <div class="w-full md:w-1/2 md:pl-4">
            <?php
            if ($posts->have_posts()) {
                while ($posts->have_posts()) {
                    $posts->the_post();
                        view('blog.post-simple', null, null, $args);
                }
            }
            wp_reset_postdata();
            ?>

        </div>

        <?php if ($container) : ?>
        </div>
    <?php endif; ?>

</div>