<?php

// Access the requires container variable. 
global $container;

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Get the text alignment.
$text_alignment = get_sub_field('text_alignment');
$content_alignment = "";

if ($text_alignment == "text-center") {
    $content_alignment = "items-center";
}

if ($text_alignment == "text-right") {
    $content_alignment = "items-end";
}

?>

<div class="relative py-10 md:py-10 <?php echo $background["colour"]; ?> <?php echo $text_alignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <?php echo ($background["colour"] == "bg-image") ? '<div class="absolute top-0 left-0 w-full h-full z-10 bg-black/50"></div>' : ""; ?>

    <?php if ($container) : ?>
        <div class="container mx-auto">
        <?php endif; ?>

        <div class="relative z-20 flex flex-col <?php echo $content_alignment; ?> animate" data-animate="animate-fade-up animate-delay-500">
            <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm mb-4'); ?>
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'), implode(" max-w-2xl ", [$titleFont, $titleStyle])); ?>
            <?php render_content(get_sub_field('content'), 'max-w-2xl', null, 'animate-fade-up animate-delay-700'); ?>
            <?php render_buttons([
                "buttons" => get_sub_field('clone_buttons', 'option'),
                "wrapClass" => "flex mt-6 " . $content_alignment,
                "animate" => "animate-fade-up animate-delay-1000"
            ]); ?>
        </div>

        <?php if ($container) : ?>
        </div>
    <?php endif; ?>

</div>