<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// A list of rotation options.
$roateClasses = ["hover:rotate-1", "hover:rotate-2", "hover:rotate-3", "hover:-rotate-1", "hover:-rotate-2", "hover:-rotate-3"];
/*<?php echo $roateClasses[mt_rand(0, 5)]; ?>*/
?>

<div class="relative py-10 <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto">

        <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
            <div class="md:mb-6">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-6', ''); ?>
            </div>
        <?php endif; ?>

        <div class="grid gap-4 grid-cols-2 md:grid-cols-3 place-items-center">
            <?php if (!empty(get_sub_field('images'))) : ?>
                <?php foreach (get_sub_field('images') as $key => $value) : ?>
                    <div class="w-full border border-smoke border-solid p-4 flex items-center justify-center ease-in-out duration-200">
                        <?php render_image($value, 'logo', true, ' max-h-[120px] w-auto select-none'); ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

    </div>
</div>