<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the images.
$images = get_sub_field('images');

?>

<div class="relative py-10 <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto">

        <div class="md:mb-10 max-w-3xl">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
            <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
        </div>

        <?php if (!empty($images[0])) {
            render_image($images[0], null, true, 'select-none');
        } ?>

    </div>
</div>