<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Handle the textured overlay
$texturedOverlay = "bg-textured-logo-light opacity-[0.03]";
if (in_array($background["colour"], array('bg-white'))) {
    $texturedOverlay = "bg-textured-logo-light opacity-40";
}

if (in_array($background["colour"], array('bg-smoke'))) {
    $texturedOverlay = "bg-textured-logo-dark opacity-[0.03]";
}
?>

<div class="relative p-10 mb-10 overlfow-hidden <?php echo ($background["colour"] == "bg-white") ? "fill-primary border border-smoke border-solid" : "fill-white"; ?> <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <blockquote>
        <?php render_title('"' . get_sub_field('title') . '"', 'p',  trim($titleFont . $titleStyle . " text-2xl md:text-3xl italic")); ?>
        <?php if (!empty(get_sub_field('cite'))) : ?>
            <div class="flex items-center gap-6">
                <span class="h-[1px] <?php echo ($background["colour"] == "bg-primary") ? "bg-white" : "bg-primary"; ?> w-10"></span>
                <?php render_title(get_sub_field('cite'), 'cite',  trim($titleFont . $titleStyle . " text-base font-bold")); ?>
            </div>
        <?php endif; ?>
    </blockquote>

    <svg class="absolute bottom-4 right-4 w-12 h-12 opacity-30" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Pro 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2025 Fonticons, Inc.-->
        <path d="M192 416c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 288c0 17.7-14.3 32-32 32l-138.7 0c-6.9 0-13.7 2.2-19.2 6.4L192 464l0-48zM64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l64 0 32 0 0 32 0 48c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416 448 416c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0zm80 144c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0z" />
    </svg>
</div>