<?php

function theme_get_post_authors(array $authors): string
{
    if (!empty($authors)) {

        // How many authors have been selected?
        if (count($authors) == 1) {
            $authors = reset($authors);

            $person_name = tangobetNews_get_team_person_name($authors);
            $return = __('By', 'tangobetNews') . " <a href='" . get_the_permalink($authors) . "' class='text-black underline'>" . $person_name . "</a>";
        } else {
            $return = __('By', 'tangobetNews') . " ";

            foreach ($authors as $author) {
                $person_name = tangobetNews_get_team_person_name($author);
                $return .= "<a href='" . get_the_permalink($author) . "' class='text-black underline'>" . $person_name . "</a>, ";
            }

            $return = rtrim($return, ", ");
        }
    } else {

        // Get the about page object.
        $about_us_page = get_field('pages_about_page', 'option');
        if (!empty($about_us_page)) {
            $return = sprintf(__('By', 'tangobetNews') . " <a href='%s' class='text-black underline'>%s</a>", [get_the_permalink($about_us_page), get_bloginfo('name')]);
        } else {
            $return = __('By', 'tangobetNews') . " " . get_bloginfo('name');
        }
    }

    return $return;
}



function theme_time_since_published()
{
    $post_date = get_the_time('U'); // Get post's timestamp
    $current_time = current_time('timestamp'); // Get current timestamp
    $time_diff = $current_time - $post_date;
    $days_ago = floor($time_diff / DAY_IN_SECONDS);

    if ($days_ago == 0) {
        return "Published today";
    } elseif ($days_ago == 1) {
        return "Published 1 day ago";
    } else {
        return "Published $days_ago days ago";
    }
}
