<?php

/**
 * ----- ----- -----
 * Include Helper Functions
 * ----- ----- -----
 */
view('blog/_helpers');

// Get the current taxonomy term
$term = get_queried_object();

// Set the background colour.
$background = ["colour" => "bg-primary"];
if (!empty(get_field('category_banner_background_image', $term))) {
    $background = ["colour" => "bg-image"];
}

// Work out the best text colour based on the background.
$textColour = determin_text_colour($background['colour'], true);

// Animation delay options.
$animation_delay = ['animate-delay-0', 'animate-delay-300', 'animate-delay-[500ms]', 'animate-delay-[700ms]'];
$animation_delay_quick = ['animate-delay-0', 'animate-delay-[1200ms]', 'animate-delay-[1300ms]', 'animate-delay-[1400ms]', 'animate-delay-[1500ms]', 'animate-delay-[1600ms]', 'animate-delay-[1700ms]', 'animate-delay-[1800ms]', 'animate-delay-[1900ms]'];

// Get the category title.
$title = get_field('category_banner_title', $term);
if (empty($title)) {
    $title = $term->name;
}

// Get the category description.
$content = get_field('category_banner_content', $term);
if (empty($content)) {
    $content = $term->description;
}

?>

<div class="banner relative min-h-[16rem] md:min-h-[24rem] px-6 flex items-center <?php echo $background['colour']; ?> <?php echo $textColour; ?> py-10 md:py-20">

    <?php if (!empty($background = get_field('category_banner_background_image', $term))) : ?>
        <img src="<?php echo $background['url']; ?>" alt="<?php echo $background['alt']; ?>" class="z-10 absolute top-0 left-0 object-cover object-center w-full h-full select-none">
    <?php endif; ?>

    <?php if (get_field('category_banner_muting_transparency', $term)) : ?>
        <div class="absolute z-20 left-0 top-0 w-full h-full <?php echo get_field('post_index_banner_overlay_colour', 'option'); ?> <?php echo get_field('category_banner_muting_transparency', $term); ?> select-none"></div>
    <?php endif; ?>

    <div class="hidden z-30 md:block absolute top-6 left-0 w-full px-6 text-left">
        <?php view('components.breadcrumbs'); ?>
    </div>

    <div class="container z-30 relative flex flex-col items-start justify-center">
        <?php render_title($title, 'h1', '', 'animate-fade-up'); ?>
        <?php render_content($content, 'max-w-xl', null, 'animate-fade-up animate-delay-500'); ?>
    </div>
</div>

<div class="container mx-auto px-6">

    <?php if (get_field(get_post_type() . '_index_include_featured_post', 'option') && !is_paged()) : ?>
        <div class="blog-posts animate" data-animate="animate-fade-up">
            <?php
            $args = array(
                'posts_per_page' => 1,
                'post_type' => 'post',
                'post_status' => 'publish',
                'post__not_in' => [get_the_id()]
            );
            $posts = new WP_Query($args);
            if ($posts->have_posts()) {
                while ($posts->have_posts()) {
                    $posts->the_post();
                    view('blog.post-simple', null, null, ["class" => "bg-primary/10 hover:bg-primary/20 ease-in-out duration-500", 'buttonColour' => "black"]);
                }
            }
            wp_reset_postdata();
            ?>

        </div>
    <?php endif; ?>

    <?php if (get_post_type() == "post" && get_field(get_post_type() . "_index_include_categories_list", 'option')) :
        $non_active_classes = "py-2 px-3 md:px-6 border text-black border-black/30 no-underline flex items-center justify-center rounded-full ease-in-out duration-300 hover:text-black hover:no-underline hover:border-black";
    ?>
        <div class="my-10 flex items-center justify-start gap-2 md:gap-4 flex-wrap">
            <a href="#all" data-term="0" class="<?php echo $non_active_classes; ?> border-secondary bg-secondary text-white hover:text-white animate" data-animate="animate-fade-up <?php echo $animation_delay_quick[2]; ?>">All</a>
            <?php
            $categories = get_categories();
            $pageCategory = get_queried_object();
            foreach ($categories as $key => $category) :
                $current = ($pageCategory->term_id == $category->term_id) ? true : false;
            ?>
                <a href="#<?php echo strtolower($category->name); ?>" data-term="<?php echo $category->term_id; ?>" class="<?php echo $non_active_classes; ?> <?php echo ($current) ? "text-white bg-secondary border-secondary hover:text-white" : ""; ?> animate" title="<?php echo $category->name; ?>" data-animate="animate-fade-up <?php echo $animation_delay_quick[$key + 2]; ?>"><?php echo $category->name; ?></a>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <main class="my-10">
        <div class="blog-posts grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6" data-page="<?php echo (get_query_var('paged')) ? get_query_var('paged') : 1; ?>">
            <?php
            $key = 1;
            if (have_posts()) :
                while (have_posts()) :
                    the_post();
                    view('blog.post', null, null, [
                        'class' => 'bg-white',
                        'animation-delay' => (isset($animation_delay[$key])) ? $animation_delay[$key] : $animation_delay[count($animation_delay) - 1],
                        'buttonColour' => str_replace('text-', '', $textColour),
                    ]);
                    $key++;
                endwhile;
            endif;
            ?>
            <?php view('components.pagination'); ?>
        </div>
    </main>

</div>

<div class="px-6 max-w-4xl mx-auto border-t border-smoke border-solid">
    <?php

    // Set up access to the blocks variables. 
    global $pageID;
    global $pageName;

    // Include global directory blocks.
    $pageName = get_post_type() . "_category_blocks_blocks";
    $pageID = $term;

    // Load the blocks system.
    view('blocks.blocks');

    ?>
</div>


<script>
    window.addEventListener("load", () => {
        jQuery(document).ready(function($) {
            // Detect click on elements with 'data-term' attribute
            $('[data-term]').on('click', function(e) {
                e.preventDefault();

                // Reset all pills.
                $('[data-term]').removeClass('bg-secondary text-white hover:text-white');

                // Set current pill to active.
                $(this).addClass('bg-secondary text-white hover:text-white');

                // Get the category ID from the data attribute
                var categoryId = $(this).data('term');
                var pagedCount = $('.blog-posts').data('page');

                // Perform the AJAX request
                $.ajax({
                    url: ajax_object.ajax_url, // 'ajaxurl' is provided by WordPress for AJAX requests
                    type: 'POST',
                    data: {
                        action: 'get_posts_by_category_id',
                        category_id: categoryId,
                        paged: pagedCount
                    },
                    success: function(response) {
                        $('.blog-posts').html(response);
                        inView('[data-animate]')
                            .on('enter', el => {
                                el.classList.add(...el.dataset.animate.split(" "));
                            })
                    },
                    error: function(xhr, status, error) {
                        $('.blog-posts').append('<p>There was an error retrieving the posts.</p>');
                    }
                });
            });
        });
    });
</script>