<?php

// Get the post category or primary category from RankMath.
$postCategory = "";
if (class_exists('RankMath')) {
    $postCategory = get_post_meta(get_the_id(), 'rank_math_primary_category', true);
    $postCategory = get_category($postCategory, 'OBJECT');
} else {
    $postCategory = get_the_category()[0];
}

// Get the title
$page_title = get_the_title();
if (!empty(get_field('display_title'))) {
    $page_title = get_field('display_title');
}
?>

<article class="post flex flex-col gap-4 border-b border-smoke/60 pb-4 mb-4 last-of-type:border-b-0 last-of-type:pb-0 last-of-type:mb-0 <?php echo (isset($data['classes'])) ? $data['classes'] : ""; ?>">
    <a href="<?php echo get_the_permalink(); ?>" class="group flex gap-4 text-inherit hover:text-primary hover:no-underline">
        <div class="w-1/2 h-48 overflow-hidden <?php echo determine_border_radius('large'); ?>">
            <?php
            if (!empty(get_post_thumbnail_id())) {
                render_image(array("ID" => get_post_thumbnail_id()), 'panels', true, 'object-cover object-center w-full h-full group-hover:scale-110 ease-in-out duration-500');
            } else {
                render_image(get_field(get_post_type() . '_index_featured_fallback', 'option'), 'square', true, 'object-cover object-center w-full h-full group-hover:scale-110 ease-in-out duration-500');
            }
            ?>
        </div>
        <div class="w-1/2 flex flex-col justify-center">

            <?php if (!empty($postCategory) && !isset($data['blocks'])) : ?>
                <div class="uppercase opacity-60 text-sm mb-2 text-black no-underline">
                    <?php echo $postCategory->name; ?>
                </div>
            <?php endif; ?>

            <?php render_title(wp_trim_words($page_title, 10, "..."), 'h2', 'leading-tight text-lg mb-0'); ?>

            <?php
            if (!empty(get_field(get_post_type() . '_index_include_post_excerpt', 'option')) && isset($data['blocks'])) {
                render_content(wp_trim_words(get_the_excerpt(), 12, "..."), 'my-3', 'text-sm leading-5');
            }
            ?>

            <div class="uppercase opacity-50 text-xs mt-1 text-black no-underline">
                <?php echo theme_time_since_published(); ?>
            </div>
        </div>
    </a>
</article>