<?php

// Get the post category or primary category from RankMath.
$postCategory = "";
if (class_exists('RankMath')) {
    $postCategory = get_post_meta(get_the_id(), 'rank_math_primary_category', true);
    $postCategory = get_category($postCategory, 'OBJECT');
} else {
    $postCategory = get_the_category()[0];
}

?>

<article class="h-full text-left group flex overflow-hidden <?php echo (isset($data['class'])) ? $data['class'] : ""; ?> <?php echo (isset($data['gridWidth'])) ? $data['gridWidth'] : ""; ?> animate" data-animate="animate-fade-up<?php echo (!empty($data['animation-delay'])) ? " " . $data['animation-delay'] : ""; ?>">
    <div class="flex flex-col">
        <div class="relative <?php echo determine_border_radius(); ?> w-full h-72 overflow-hidden ease-in-out duration-500 bg-secondary-400">
            <a href="<?php echo get_the_permalink(); ?>" title="View post">
                <?php
                if (!empty(get_post_thumbnail_id())) {
                    render_image(array("ID" => get_post_thumbnail_id()), 'square', true, 'object-cover object-center w-full h-full group-hover:scale-110 group-hover:-rotate-3 ease-in-out duration-500');
                } else {
                    render_image(get_field(get_post_type() . '_index_featured_fallback', 'option'), 'square', true, 'object-cover object-center w-full h-full group-hover:scale-110 group-hover:-rotate-3 ease-in-out duration-500');
                }
                ?>
            </a>
        </div>
        <div class="py-6 grow flex flex-col justify-between">
            <div>
                <div class="uppercase opacity-50 text-xs mb-2 text-black no-underline">
                    <?php echo theme_time_since_published(); ?>
                </div>

                <a href="<?php echo get_the_permalink(); ?>" title="View post" class="text-inherit no-underline ease-in-out duration-500">
                    <?php render_title(wp_trim_words(get_the_title(), 9, "..."), 'h2', 'leading-tight text-lg md:text-2xl mb-4'); ?>
                </a>

                <?php
                if (!empty(get_field(get_post_type() . '_index_include_post_excerpt', 'option'))) {
                    render_content(wp_trim_words(get_the_excerpt(), 30, "..."), 'mb-4', 'text-sm');
                }
                ?>

                <?php
                if (!empty(get_field(get_post_type() . '_index_include_post_author', 'option'))) {
                    // Get the post author.
                    render_title("Written by " . get_the_author_meta('display_name'), 'p', 'my-4 text-sm font-bold');
                }
                ?>
            </div>
            <div>
                <?php
                render_buttons([
                    "buttons" => array(
                        array(
                            "link" => array(
                                "url" => get_the_permalink(),
                                "title" => __('Read More', 'tangobetNews'),
                            ),
                            "style" => "keyline",
                            "colour" => 'primary'
                        ),
                    ),
                    "size" => "small",
                ]);
                ?>
            </div>
        </div>
    </div>
</article>