<div class="hidden md:block 2xl:pl-28">

    <a href="<?php echo get_post_type_archive_link('insights'); ?>rss/" class="uppercase hover:no-underline font-extrabold px-8 mb-4 text-white bg-primary hover:dark-primary rounded-full text-base flex items-center justify-between py-5"><span>Subscribe</span> <i class="fas fa-rss duration-300 ease-in-out"></i></a>

    <div class="font-extrabold px-8 mb-16 text-black bg-white shadow-lg rounded-full text-base flex items-center justify-between py-5">
        <?php get_search_form(); ?>
    </div>

    <?php // Categories // ?>
    <div data-accordion="sidebar" class="">
        <div class="border-black border-solid border-b-[1px]">
            <div class="head flex items-center justify-between py-5">
                <button type="button" class="flex justify-between items-center w-full font-medium text-left" data-accordion-target="#accordion-body-sidebar-1" aria-expanded="false" aria-controls="accordion-body-sidebar-1">
                    <?php render_title('Categories', 'h3', 'text-base font-bold tracking-widest uppercase mb-0 font-sans'); ?>
                    <div class="indicator-icon ml-6">
                        <i class="fas fa-caret-down"></i>
                        <i class="fas fa-caret-up"></i>
                    </div>
                </button>
            </div>
            <div id="accordion-body-sidebar-1" aria-labelledby="accordion-body-sidebar-1" class="body text-sm">
                <div class="pb-10">
                    <a href="<?php echo get_permalink(get_option('page_for_posts')); ?>" class="flex text-primary pt-2 hover:text-black">
                        <p class="text-base lh1 mb-0">All Categories</p>
                    </a>
                    <?php 
                    $terms = get_categories();

                    if (!empty($terms) && count($terms) > 1) :
                        foreach ($terms as $term) :
                    ?>
                        <a href="<?php echo get_term_link($term); ?>" class="flex text-primary pt-2 hover:text-black">
                            <p class="text-base lh1 mb-0"><?php echo $term->name; ?></p>
                        </a>
                    <?php endforeach;
                    endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php // Tags // ?>
    <div data-accordion="sidebar" class="">
        <div class="border-black border-solid border-b-[1px]">
            <div class="head flex items-center justify-between py-5">
                <button type="button" class="flex justify-between items-center w-full font-medium text-left" data-accordion-target="#accordion-body-sidebar-1" aria-expanded="false" aria-controls="accordion-body-sidebar-1">
                    <?php render_title('Tags', 'h3', 'text-base font-bold tracking-widest uppercase mb-0 font-sans'); ?>
                    <div class="indicator-icon ml-6">
                        <i class="fas fa-caret-down"></i>
                        <i class="fas fa-caret-up"></i>
                    </div>
                </button>
            </div>
            <div id="accordion-body-sidebar-1" aria-labelledby="accordion-body-sidebar-1" class="body text-sm">
                <div class="pb-10">
                    <a href="<?php echo get_permalink(get_option('page_for_posts')); ?>" class="flex text-primary pt-2 hover:text-black">
                        <p class="text-base lh1 mb-0">All Tags</p>
                    </a>
                    <?php 
                    $terms = get_terms(
                        array(
                            'taxonomy' => 'post_tag',
                            'hide_empty' => true,
                        )
                    );

                    if (!empty($terms) && count($terms) > 0) :
                        foreach ($terms as $term) :
                    ?>
                        <a href="<?php echo get_term_link($term); ?>" class="flex text-primary pt-2 hover:text-black">
                            <p class="text-base lh1 mb-0"><?php echo $term->name; ?></p>
                        </a>
                    <?php endforeach;
                    endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php // Authors // ?>
    <div data-accordion="sidebar" class="">
        <div class="border-black border-solid border-b-[1px]">
            <div class="head flex items-center justify-between py-5">
                <button type="button" class="flex justify-between items-center w-full font-medium text-left" data-accordion-target="#accordion-body-sidebar-2" aria-expanded="false" aria-controls="accordion-body-sidebar-2">
                    <?php render_title('Authors', 'h3', 'text-base font-bold tracking-widest uppercase mb-0 font-sans'); ?>
                    <div class="indicator-icon ml-6">
                        <i class="fas fa-caret-down"></i>
                        <i class="fas fa-caret-up"></i>
                    </div>
                </button>
            </div>
            <div id="accordion-body-sidebar-2" aria-labelledby="accordion-body-sidebar-2" class="body text-sm">
                <div class="pb-10 flex flex-wrap">
                    <?php 
                    $authors = get_users(
                        array(
                            'orderby' => 'display_name',
                            'order'   => 'ASC'
                        )
                    );

                    if (!empty($authors) && count($authors) > 0) :
                        foreach ($authors as $author) :
                    ?>
                        <a href="<?php echo get_term_link($term); ?>" class="flex text-primary pt-2 hover:text-black">
                            <p class="text-base lh1 mb-0"><?php echo $author->display_name; ?> (<?php echo count_user_posts($author->ID, ['post']); ?>)</p>
                        </a>
                    <?php endforeach;
                    endif; ?>
                </div>
            </div>
        </div>
    </div>


</div>