<?php

/**
 * ----- ----- -----
 * Include Helper Functions
 * ----- ----- -----
 */
view('blog/_helpers');

// Get the title
$page_title = get_the_title();
if (!empty(get_field('display_title'))) {
    $page_title = get_field('display_title');
}

// Get the current category.
$current_post_categories = get_the_category();

?>

<?php if (get_field('post_single_include_post_banner', 'option')) : ?>
    <div class="banner relative min-h-[16rem] md:min-h-[24rem] px-6 mb-6 lg:mb-14 flex items-center <?php echo (!empty(get_field('post_banner_background_image'))) ? "bg-image" : "bg-primary"; ?> <?php echo determin_text_colour('bg-image'); ?> <?php echo $textColour; ?> py-10 md:py-20">

        <?php if (!empty($background = get_field('post_banner_background_image'))) : ?>
            <img src="<?php echo $background['url']; ?>" alt="<?php echo $background['alt']; ?>" class="z-10 absolute top-0 left-0 object-cover object-center w-full h-full select-none">
        <?php endif; ?>

        <?php if (get_field('post_banner_muting_transparency')) : ?>
            <div class="absolute z-20 left-0 top-0 w-full h-full <?php echo get_field('post_index_banner_overlay_colour', 'option'); ?> <?php echo get_field('post_banner_muting_transparency'); ?> select-none"></div>
        <?php endif; ?>

        <div class="hidden z-30 md:block absolute top-6 left-0 w-full px-6 text-left">
            <?php view('components.breadcrumbs'); ?>
        </div>

        <div class="container z-30 relative flex flex-col items-start justify-center">
            <?php render_title($page_title, 'h1', 'mb-6 font-display text-normal max-w-4xl uppercase', 'animate-fade-up'); ?>
            <?php render_title(get_field('secondary_title'), 'p', 'mb-6 font-display text-normal max-w-4xl text-lg md:text-2xl', 'animate-fade-up animate-delay-[00ms]'); ?>
        </div>
    </div>
<?php endif; ?>

<main>
    <?php if (!get_field('post_single_include_post_banner', 'option')) : ?>
        <div class="border-b border-solid border-smoke/60 py-2 px-6">
            <?php view('components.breadcrumbs'); ?>
        </div>
    <?php endif; ?>
    <div class="container mx-auto px-6">
        <?php if (!get_field('post_single_include_post_banner', 'option')) : ?>
            <div class="py-10 md:py-16">
                <?php render_title($page_title, 'h1', 'mb-6 font-display text-normal max-w-4xl uppercase', 'animate-fade-up'); ?>
                <?php render_title(get_field('secondary_title'), 'p', 'mb-6 font-display text-normal max-w-4xl text-2xl', 'animate-fade-up animate-delay-[00ms]'); ?>

                <?php if (!get_field('post_single_include_feature_image', 'option')) : ?>
                    <div class="border-t border-solid border-smoke pt-4">
                        <span class="opacity-70"><?php _e('Category', 'tangobet'); ?>: <a href="<?php echo get_term_link($current_post_categories[0]); ?>" class="text-inherit hover:text-primary"><?php echo $current_post_categories[0]->name; ?></a></span>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="flex flex-wrap">
            <div class="w-full md:w-2/3 md:pr-6">
                <?php if (get_field('post_single_include_feature_image', 'option')) : ?>
                    <div class="relative animate" data-animate="animate-fade-up animate-delay-[300ms]">
                        <?php render_image(array("ID" => get_post_thumbnail_id()), 'content-width', true, 'w-full select-none ' . determine_border_radius('large')); ?>
                        <span class="absolute top-0 left-0 px-6 py-2 uppercase text-sm font-bold bg-white after:content-[''] after:w-5 after:h-5 after:absolute after:top-[2.3rem] after:ml-[1.52rem] after:bg-white"><?php echo $current_post_categories[0]->name; ?></span>
                    </div>
                <?php endif; ?>

                <div class="animate" data-animate="animate-fade-up animate-delay-[600ms]">
                    <?php render_content(get_the_content(), 'mt-10'); ?>
                </div>

                <?php

                // Set up access to the blocks variables. 
                global $pageID;
                global $pageName;

                // Include global directory blocks.
                $pageName = "blocks";
                $pageID = get_the_id();

                // Load the blocks system.
                view('blocks.blocks');

                ?>

            </div>
            <div class="w-full md:w-1/3 md:pl-6 animate" data-animate="animate-fade-up animate-delay-[600ms]">
                <div class="hidden md:block">
                    <?php render_title(get_field('post_single_sidebar_related_post_title', 'option'), 'h2', 'text-2xl pb-4 mb-4 border-b border-solid border-smoke/60'); ?>
                    <?php
                    $category_ids = array_map(function ($category) {
                        return $category->term_id;
                    }, $current_post_categories);

                    $query_args = [
                        'posts_per_page' => get_field('post_single_sidebar_number_of_sidebar_posts', 'option'),
                        'orderby' => 'date',
                        'order' => 'DESC',
                        'category__in' => $category_ids,
                        'post__not_in' => [get_the_ID()]
                    ];

                    $latest_posts_query = new WP_Query($query_args);

                    if ($latest_posts_query->have_posts()) {
                        while ($latest_posts_query->have_posts()) {
                            $latest_posts_query->the_post(); // Set up post data
                            view('blog.post-simple');
                        }

                        wp_reset_postdata();
                    } else {
                        echo '<p>No related posts found.</p>';
                    }
                    ?>
                </div>

                <div class="sticky md:top-52">
                    <?php if (!empty(get_field('post_single_sidebar_advert_position_1', 'option'))) : ?>
                        <div class=" my-10">
                            <?php render_image(get_field('post_single_sidebar_advert_position_1', 'option'), array(400, null), true, 'mx-auto'); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (get_field('post_single_include_socials', 'option')) : ?>
                        <div class="hidden md:block mt-10">
                            <?php render_title(get_field('post_single_sidebar_social_section_title', 'option'), 'h2', 'text-2xl pb-4 mb-4 border-b border-solid border-smoke/60'); ?>
                            <?php render_social_icons(
                                'list-none flex m-0 my-6 p-0 mr-3 last:mr-0',
                                'w-9 h-9 flex items-center mx-1 justify-center fill-black border border-smoke rounded hover:bg-white hover:fill-primary ease-in-out duration-500',
                                'w-6 h-6'
                            ); ?>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
</main>

<div class="bg-white px-6">
    <div class="container mx-auto">
        <?php if (get_field('post_single_include_share', 'option')) : ?>
            <div class="my-10 md:my-20">
                <div class="animate" data-animate="animate-fade-up animate-delay-1000">
                    <div class="flex flex-col items-center" data-animate="animate-shake animate-once animate-duration-300 animate-delay-[4000ms] animate-ease-in-out animate-alternate" data-animate-remove>
                        <?php if (!empty(get_field('post_single_share_title', 'option'))) : ?>
                            <div class="text-lg font-bold mb-2"><?php echo get_field('post_single_share_title', 'option'); ?></div>
                        <?php endif; ?>
                        <?php view('components.share', null, null, [
                            "wrapClass" => "list-none flex gap-2 m-0 p-0",
                            "class" => "mb-0 w-8 h-8 flex items-center justify-center rounded-lg fill-black hover:fill-primary ease-in-out duration-500",
                            "svgClass" => "w-5 h-5",
                        ]); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>


<div class="bg-smoke/10 px-6">
    <div class="container z-20 relative mx-auto py-10 md:py-20">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="max-w-4xl">
                <?php render_title(get_field(get_post_type() . '_single_related_posts_title', 'option'), 'h2', 'mb-0'); ?>
            </div>
            <?php
            render_buttons([
                "buttons" => array(
                    array(
                        "link" => array(
                            "url" => get_the_permalink(get_option('page_for_posts')),
                            "title" => __('View all', 'tangobetNews')
                        ),
                        "style" => "keyline",
                        "colour" => "smoke"
                    )
                ),
                "wrapClass" => "flex items-center justify-center mt-4"
            ]);
            ?>

        </div>
        <div class="relative w-full lg:px-10 overflow-hidden">
            <div class="pt-6 grid grid-cols-1 lg:grid-cols-3 gap-3 md:gap-8 md:-mx-8">
                <?php
                $args = array(
                    'posts_per_page' => 3,
                    'post_type' => 'post',
                    'post_status' => 'publish',
                    'post__not_in' => array(get_the_id())
                );
                $posts = new WP_Query($args);
                if ($posts->have_posts()) {
                    while ($posts->have_posts()) {
                        $posts->the_post();
                        view('blog.post', null, null, ["buttonColour" => 'black']);
                    }
                }
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>
</div>