<?php
global $wp_query;

if (isset($data) && !empty($data)) {
    $wp_query = $data;
} else {
    $wp_query = $wp_query;
}

// Pagination arguments. 
$args = array(
    "mid_size" => 2,
    "prev_text" => 'Previous',
    "next_text" => 'Next',
    "type" => "list"
);

// Manually set the total pages to account for the offet which 
// was creating an extra page which 404'ed.
$total_pages = 0;
if (get_field(get_post_type() . '_index_include_featured_post', 'option')) {
    if (!is_admin() && $wp_query->is_main_query() && is_home())  {
        $args['total'] = ceil(($wp_query->found_posts - 1) / $wp_query->query_vars['posts_per_page']);
    }
}

if ($wp_query->max_num_pages > 1) : ?>

    <div class="clearfix mt-10 col-span-full" data-element="pagination">
        <?php
        echo paginate_links($args);
        ?>
    </div>

<?php endif; ?>