<?php do_action('tangobetNews_content_after'); ?>

<footer id="colophon" class="relative bg-black text-white px-6 py-16 mt-10" role="contentinfo">
    <div class="relative z-10 container mx-auto">

        <a href="<?php echo home_url(); ?>" title="Return to the <?php bloginfo('name'); ?> homepage">
            <?php render_image(get_field('footer_logo', 'option'), array(200, 60), true, 'mb-4 mx-auto max-w-[10rem]'); ?>
        </a>

        <?php if (get_field('footer_enable_socials', 'option')) : ?>
            <div class="container mx-auto flex items-center justify-center mb-6">
                <?php render_social_icons(
                    'list-none flex m-0 my-6 p-0 mr-3 last:mr-0',
                    'w-9 h-9 flex items-center mx-1 justify-center fill-white rounded hover:bg-white hover:fill-primary ease-in-out duration-500',
                    'w-6 h-6'
                ); ?>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols grid-cols-2 md:grid-cols-3 lg:grid-cols-6 border-t border-b border-smoke border-solid py-6 mb-6">
            <?php
            $i = 0;
            $index = ['one', 'two', 'three', 'four', 'five', 'six'];
            $footer_column_titles = get_field('footer_column_titles', 'option');
            while ($i <= 5) : ?>
                <div class="mb-6 md:mb-0">
                    <?php render_title($footer_column_titles['column_' . $index[$i]], 'div', 'text-base font-bold text-center mb-4'); ?>
                    <?php
                    if (has_nav_menu('footer-' . $index[$i])) {
                        wp_nav_menu(array(
                            'theme_location' => 'footer-' . $index[$i],
                            'container' => 'div',
                            'container_class' => 'footer-menu'
                        ));
                    }
                    ?>
                </div>
            <?php
                $i++;
            endwhile;
            ?>
        </div>

        <?php if (!empty($footer_logos = get_field('footer_logos', 'option'))) : ?>
            <div class="w-full flex flex-wrap items-center justify-center gap-6 py-10">
                <?php foreach ($footer_logos as $logo) :
                    $attachment_link_url = get_field('image_link', 'attachment_' . $logo['id']);
                ?>
                    <?php if (!empty($attachment_link_url)) : ?>
                        <a href="<?php echo $attachment_link_url; ?>" alt="<?php echo $logo['alt']; ?>">
                        <?php endif; ?>
                        <?php render_image($logo, array(200, 60), true, 'opacity-60 hover:opacity-100 min-h-[30px] max-h-[40px] ease-in-out duration-500'); ?>
                        <?php if (!empty($attachment_link_url)) : ?>
                        </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <div>
            <?php render_content(get_field('footer_content', 'option'), 'text-center opacity-70', 'text-xs mb-2'); ?>
        </div>

    </div>
</footer>

<?php if (get_field('footer_enable_gamble_aware_banner', 'option')) : ?>
    <div class="bg-[#ffae7f] py-4 px-4">
        <div class="container mx-auto">
            <?php if (!empty($image = get_field('footer_gamble_aware_banner', 'option'))) :
                $attachment_link_url = get_field('image_link', 'attachment_' . $image['id']);
            ?>
                <?php if (!empty($attachment_link_url)) : ?>
                    <a href="<?php echo $attachment_link_url; ?>" alt="<?php echo $logo['alt']; ?>">
                    <?php endif; ?>
                    <?php render_image($image, 'full', true, 'mx-auto max-h-[80px] max-w-[46rem]'); ?>
                    <?php if (!empty($attachment_link_url)) : ?>
                    </a>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>