<header class="fixed bg-primary w-full z-40" data-menu-state="0" data-scrolled="0">

    <div class="px-6 py-2 border-b border-white/40 border-solid flex items-center justify-end md:justify-between">
        <?php
        if (has_nav_menu('quick-menu')) {
            wp_nav_menu(array(
                'theme_location' => 'quick-menu',
                'container' => 'div',
                'container_class' => 'header-menu header-quick-links'
            ));
        }
        ?>
        <div class="hidden md:block">
            <?php
            if (has_nav_menu('account-menu')) {
                wp_nav_menu(array(
                    'theme_location' => 'account-menu',
                    'container' => 'div',
                    'container_class' => 'header-menu'
                ));
            }
            ?>
        </div>
    </div>

    <div class="flex items-center justify-between px-6 py-3">
        <div class="flex items-center w-6/12 md:w-3/12">
            <a href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?> Homepage" class="block md:mr-10">
                <?php render_image(get_field('header_logo', 'option'), array(200, 80), true, 'w-full h-full max-w-[8rem] md:max-w-[10rem]'); ?>
            </a>
        </div>
        <div class="flex items-center justify-end gap-8 w-6/12 md:w-3/12">
            <div class="hidden md:flex gap-4">
                <?php
                if (!empty($button = get_field('header_secondary_button', 'option'))) {
                    render_buttons([
                        "buttons" => array(
                            array(
                                "link" => array(
                                    "url" => $button['url'],
                                    "title" => $button['title']
                                ),
                                "style" => "keyline",
                                "colour" => "white",
                            )
                        ),
                        "icon" => "",
                        "remove_class" => "mb-4",
                    ]);
                }
                if (!empty($button = get_field('header_primary_button', 'option'))) {
                    render_buttons([
                        "buttons" => array(
                            array(
                                "link" => array(
                                    "url" => $button['url'],
                                    "title" => $button['title']
                                ),
                                "style" => "solid",
                                "colour" => "white"
                            )
                        ),
                        "remove_class" => "mb-4",
                    ]);
                }
                ?>
            </div>
            <div class="header-breakpoint:hidden">
                <div class="h-full py-2 mb-0">
                    <label class="hamburger" for="check" title="Toggle Mobile Menu">
                        <input type="checkbox" id="check" />
                        <span></span>
                        <span></span>
                        <span></span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="px-6 flex items-center justify-start">
        <div class="hidden header-breakpoint:block" data-menu="desktop">
            <?php
            if (has_nav_menu('desktop-menu')) {
                wp_nav_menu(array(
                    'theme_location' => 'desktop-menu',
                    'container' => 'div',
                    'container_class' => 'desktop-menu'
                ));
            }
            ?>
        </div>
    </div>

    <div data-menu="mobile-menu">
        <?php
        if (has_nav_menu('mobile-menu')) {
            wp_nav_menu(array(
                "theme_location" => "mobile-menu",
            ));
        }
        ?>
    </div>

</header>
<div class="header-clear"></div>