<?php

// Get the page title. 
$title = get_the_title();
if (get_field('title')) {
    $title = get_field('title');
}

// Set the background colour.
$background = ["colour" => "bg-primary"];

?>

<div class="banner relative <?php echo $background['colour']; ?> <?php echo determin_text_colour($background['colour']); ?> py-10 md:py-20">

    <div class="hidden md:block absolute top-6 left-0 w-full px-6 text-left">
        <?php view('components.breadcrumbs'); ?>
    </div>

    <div class="container relative flex flex-col items-center justify-center text-center min-h-[15rem]">
        <?php render_title($title, 'h1', 'max-w-xl'); ?>
        <?php render_content(get_field('content'), 'text-lg max-w-lg'); ?>
    </div>
</div>

<div class="container mx-auto py-20">
    <main>
        <a href="<?php echo get_home_url(); ?>" class="block text-2xl text-center p-4 bg-primary-400/30 border border-smoke border-solid mb-4 text-black no-underline hover:underline hover:text-primary" title="Visit Home">Home</a>
        <?php

        // Check if plugin funcations are included.
        if (!function_exists('is_plugin_active')) {
            require_once(ABSPATH . 'wp-admin/includes/plugin.php');
        }

        // Check if Rank Math is installed and active?
        if (is_plugin_active('seo-by-rank-math/rank-math.php')) {
            echo do_shortcode('[rank_math_html_sitemap]');
        }

        ?>
    </main>
</div>