const _ = require("lodash");

module.exports = {
    mode: 'jit',
    content: [
        './*/*.php',
        './**/*.php',
        './resources/css/*.css',
        './resources/js/*.js',
    ],
    theme: {
        container: {
            center: true
        },
        fontFamily: {
            'sans': ['Open Sans', 'sans-serif'],
            'display': ['Open Sans', 'sans-serif'],
        },
        fontSize: {
            'xs': '.75rem',
            'sm': '.9rem',
            'base': '1rem',
            'lg': '1.1rem',
            'xl': '1.3rem',
            '2xl': '1.4rem',
            '3xl': '1.6rem',
            '4xl': '2rem',
            '5xl': '4rem',
            '6xl': '5rem',
            '7xl': '6rem',
        },
        extend: {
            colors: {
                primary: '#ee3124',
                // primary: '#0077b6',
                secondary: '#f4c041',
                white: '#FFFFFF',
                smoke: '#ededed',
                black: '#222222',
                transparent: 'transparent',
                inherit: 'inherit',
                debug: '#E818D8',
            },

            maxWidth: {
                'edge': '1800px',
            },

            borderRadius: {
                '4xl': '2rem',
                '6xl': '4rem',
                '8xl': '8rem'
            },             
        },
        
        screens: {
            'sm': '640px',
            'md': '768px',
            'lg': '1024px',
            'xl': '1140px',
            '2xl': '1310px',
            'header-breakpoint': '985px',
        }
    },
    safelist : [
        'alignfull',
        'alignwide',
        'aligncenter',
        'alignnone',
        'alignright',
        'wp-block-button',
        'wp-caption',
        'wp-caption-text',
        'aspect-video',
        'bg-primary', 'bg-secondary', 'bg-black', 'bg-white', 'bg-smoke', 'bg-transparent',
        'text-primary', 'text-secondary', 'text-black', 'text-smoke', 'text-white', 'text-sans', 'text-display',
        'normal-case', 'capitalize', 'uppercase',
        'opacity-0', 'opacity-5', 'opacity-10', 'opacity-20', 'opacity-25', 'opacity-30', 'opacity-40', 'opacity-50', 'opacity-60', 'opacity-70', 'opacity-75', 'opacity-80', 'opacity-90', 'opacity-95', 'opacity-100'
    ],
    plugins: [
        require('tailwindcss-animated')
    ]
};
